/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.oauth;

import com.openexchange.admin.rmi.OXUserInterface;
import com.openexchange.admin.rmi.dataobjects.Context;
import com.openexchange.admin.rmi.dataobjects.Credentials;
import com.openexchange.admin.rmi.dataobjects.User;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.oauth.actions.AllOAuthServicesRequest;
import com.openexchange.ajax.oauth.actions.GetOAuthServiceRequest;
import com.openexchange.ajax.oauth.actions.OAuthServicesResponse;
import com.openexchange.ajax.oauth.types.OAuthService;
import com.openexchange.configuration.AJAXConfig;
import com.openexchange.exception.OXException;
import java.io.IOException;
import java.rmi.Naming;
import java.util.List;
import org.json.JSONException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class OAuthServiceTest {
    private static final String TESTSERVICE = "com.openexchange.oauth.testservice";
    private AJAXClient client;

    @BeforeClass
    public static void beforeClass() throws Exception {
        AJAXClient.User oxadmin = AJAXClient.User.OXAdmin;
        AJAXClient client2 = new AJAXClient(AJAXClient.User.User2);
        User user = new User(client2.getValues().getUserId());
        user.setUserAttribute("config", "com.openechange.oauth.testservice.enabled", "false");
        Credentials credentials = new Credentials(AJAXConfig.getProperty(oxadmin.getLogin()), AJAXConfig.getProperty(oxadmin.getPassword()));
        OXUserInterface iface = (OXUserInterface)Naming.lookup("rmi://" + AJAXConfig.getProperty(AJAXConfig.Property.RMI_HOST) + ":1099/" + "OXUser_V2");
        iface.change(new Context(Integer.valueOf(client2.getValues().getContextId())), user, credentials);
        client2.logout();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        AJAXClient.User oxadmin = AJAXClient.User.OXAdmin;
        AJAXClient client2 = new AJAXClient(AJAXClient.User.User2);
        User user = new User(client2.getValues().getUserId());
        user.setUserAttribute("config", "com.openechange.oauth.testservice.enabled", null);
        Credentials credentials = new Credentials(AJAXConfig.getProperty(oxadmin.getLogin()), AJAXConfig.getProperty(oxadmin.getPassword()));
        OXUserInterface iface = (OXUserInterface)Naming.lookup("rmi://" + AJAXConfig.getProperty(AJAXConfig.Property.RMI_HOST) + ":1099/" + "OXUser_V2");
        iface.change(new Context(Integer.valueOf(client2.getValues().getContextId())), user, credentials);
        client2.logout();
    }

    @Before
    public void setUp() throws Exception {
        this.client = new AJAXClient(AJAXClient.User.User1);
    }

    @After
    public void tearDown() throws Exception {
        if (this.client != null) {
            this.client.logout();
        }
    }

    @Test
    public void testGetAllServices() throws OXException, IOException, JSONException {
        OAuthServicesResponse response = this.client.execute(new AllOAuthServicesRequest());
        List<OAuthService> services = response.getServices();
        boolean found = false;
        for (OAuthService service : services) {
            if (!TESTSERVICE.equals(service.getId())) continue;
            found = true;
            break;
        }
        Assert.assertTrue((String)"Service is missing: 'com.openexchange.oauth.testservice'", (boolean)found);
    }

    @Test
    public void testGetTestService() throws OXException, IOException, JSONException {
        OAuthServicesResponse response = this.client.execute(new GetOAuthServiceRequest(TESTSERVICE));
        List<OAuthService> services = response.getServices();
        Assert.assertEquals((String)"Get response should contain exactly one service", (long)1L, (long)services.size());
        OAuthService service = services.get(0);
        Assert.assertEquals((String)"Service is missing: 'com.openexchange.oauth.testservice'", (Object)TESTSERVICE, (Object)service.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetAllServicesWithoutPermission() throws Exception {
        AJAXClient client2 = null;
        try {
            client2 = new AJAXClient(AJAXClient.User.User2);
            OAuthServicesResponse response = client2.execute(new AllOAuthServicesRequest());
            List<OAuthService> services = response.getServices();
            boolean found = false;
            for (OAuthService service : services) {
                if (!TESTSERVICE.equals(service.getId())) continue;
                found = true;
                break;
            }
            Assert.assertFalse((String)"Service is present without permission: 'com.openexchange.oauth.testservice'", (boolean)found);
        }
        finally {
            if (client2 != null) {
                client2.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetTestServiceWithoutPermission() throws Exception {
        AJAXClient client2 = null;
        try {
            client2 = new AJAXClient(AJAXClient.User.User2);
            OAuthServicesResponse response = client2.execute(new GetOAuthServiceRequest(TESTSERVICE, false));
            Assert.assertTrue((String)"Response should contain error", (boolean)response.hasError());
            OXException e = response.getException();
            Assert.assertEquals((String)("An unexpected error occurred: " + e.getMessage()), (Object)"OAUTH-0004", (Object)e.getErrorCode());
        }
        finally {
            if (client2 != null) {
                client2.logout();
            }
        }
    }
}

