/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mobilenotifier;

import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.mobilenotifier.actions.MobileNotifierSubscribeRequest;
import com.openexchange.ajax.mobilenotifier.actions.MobileNotifierUnsubscribeRequest;
import com.openexchange.ajax.mobilenotifier.actions.MobileNotifierUpdateTokenRequest;
import org.json.JSONObject;

public class MobileNotifierLifecycleTest
extends AbstractAJAXSession {
    public MobileNotifierLifecycleTest(String name) {
        super(name);
    }

    public void testSubscriptionLifecycle() throws Exception {
        String startToken = "ADE9219010FD3DEAD9211384129";
        String serviceId = "gcm";
        String providerId = "mail";
        String newToken = "ACCCDDDDEEEAAA000111155";
        MobileNotifierSubscribeRequest msReq = new MobileNotifierSubscribeRequest(serviceId, providerId, startToken, true);
        AbstractAJAXResponse msResp = this.client.execute(msReq);
        MobileNotifierLifecycleTest.assertNotNull((Object)((Object)msResp));
        this.assertEmptyJson(msResp);
        MobileNotifierUpdateTokenRequest utReq = new MobileNotifierUpdateTokenRequest(serviceId, startToken, newToken, true);
        msResp = null;
        msResp = this.client.execute(utReq);
        MobileNotifierLifecycleTest.assertNotNull((Object)((Object)msResp));
        this.assertEmptyJson(msResp);
        MobileNotifierUnsubscribeRequest musReq = new MobileNotifierUnsubscribeRequest(serviceId, providerId, newToken, true);
        msResp = null;
        msResp = this.client.execute(musReq);
        MobileNotifierLifecycleTest.assertNotNull((Object)((Object)msResp));
        this.assertEmptyJson(msResp);
    }

    private void assertEmptyJson(AbstractAJAXResponse resp) {
        if (resp.getData() instanceof JSONObject) {
            JSONObject jObj = (JSONObject)resp.getData();
            MobileNotifierLifecycleTest.assertTrue((String)("Returning JSON data is not empty: " + jObj.toString()), (boolean)jObj.isEmpty());
        } else {
            MobileNotifierLifecycleTest.assertFalse((String)"Returning data is not a json response", (boolean)true);
        }
    }
}

