/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mailaccount;

import com.openexchange.ajax.mailaccount.AbstractMailAccountTest;
import com.openexchange.ajax.mailaccount.actions.MailAccountDeleteRequest;
import com.openexchange.ajax.mailaccount.actions.MailAccountGetRequest;
import com.openexchange.ajax.mailaccount.actions.MailAccountGetResponse;
import com.openexchange.ajax.mailaccount.actions.MailAccountInsertRequest;
import com.openexchange.ajax.mailaccount.actions.MailAccountInsertResponse;
import com.openexchange.mailaccount.MailAccountDescription;
import java.util.UUID;

public class MailAccountStartTlsTest
extends AbstractMailAccountTest {
    private MailAccountDescription mailAccount;

    public MailAccountStartTlsTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.mailAccount = null;
    }

    @Override
    public void tearDown() throws Exception {
        if (null != this.mailAccount) {
            MailAccountDeleteRequest req = new MailAccountDeleteRequest(this.mailAccount.getId());
            this.client.execute(req);
        }
        super.tearDown();
    }

    public void testCreateMailAccountWithStartTls() throws Exception {
        MailAccountDescription acc = MailAccountStartTlsTest.createMailAccountObject();
        acc.setName(UUID.randomUUID().toString());
        acc.setMailStartTls(true);
        acc.setTransportStartTls(true);
        MailAccountInsertRequest req = new MailAccountInsertRequest(acc, false);
        MailAccountInsertResponse resp = this.client.execute(req);
        MailAccountStartTlsTest.assertFalse((String)resp.getErrorMessage(), (boolean)resp.hasError());
        resp.fillObject(acc);
        MailAccountGetRequest getReq = new MailAccountGetRequest(acc.getId());
        MailAccountGetResponse getResp = this.client.execute(getReq);
        MailAccountStartTlsTest.assertFalse((String)getResp.getErrorMessage(), (boolean)getResp.hasError());
        this.mailAccount = getResp.getAsDescription();
        MailAccountStartTlsTest.assertTrue((boolean)this.mailAccount.isMailStartTls());
        MailAccountStartTlsTest.assertTrue((boolean)this.mailAccount.isTransportStartTls());
    }

    public void testCreateMailAccountWithDefaults() throws Exception {
        MailAccountDescription acc = MailAccountStartTlsTest.createMailAccountObject();
        acc.setName(UUID.randomUUID().toString());
        MailAccountInsertRequest req = new MailAccountInsertRequest(acc, false);
        MailAccountInsertResponse resp = this.client.execute(req);
        MailAccountStartTlsTest.assertFalse((String)resp.getErrorMessage(), (boolean)resp.hasError());
        resp.fillObject(acc);
        MailAccountGetRequest getReq = new MailAccountGetRequest(acc.getId());
        MailAccountGetResponse getResp = this.client.execute(getReq);
        MailAccountStartTlsTest.assertFalse((String)getResp.getErrorMessage(), (boolean)getResp.hasError());
        this.mailAccount = getResp.getAsDescription();
        MailAccountStartTlsTest.assertFalse((boolean)this.mailAccount.isMailStartTls());
        MailAccountStartTlsTest.assertFalse((boolean)this.mailAccount.isTransportStartTls());
    }
}

