/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail.categories;

import com.openexchange.ajax.mail.MailTestManager;
import com.openexchange.ajax.mail.actions.NewMailRequest;
import com.openexchange.ajax.mail.categories.AbstractMailCategoriesTest;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.search.Order;
import com.openexchange.mail.dataobjects.MailMessage;
import java.io.IOException;
import org.json.JSONException;

public class TrainTest
extends AbstractMailCategoriesTest {
    private static final int[] COLUMNS = new int[]{102, 600, 601, 602, 603, 604, 605, 606, 607, 608, 610, 611, 614, 652};

    public TrainTest(String name) throws OXException, IOException, JSONException {
        super(name);
    }

    public void testTrain() throws Exception {
        MailTestManager manager = new MailTestManager(this.client, false);
        this.getClient().execute(new NewMailRequest(this.getInboxFolder(), this.EML, -1, true));
        String origin = this.values.getInboxFolder();
        manager.trainCategory("social", false, true, this.getSendAddress());
        MailMessage[] messages = manager.listMails(origin, COLUMNS, 610, Order.DESCENDING, true, "general");
        TrainTest.assertTrue((String)"General category should still contain the old email!", (messages.length == 1 ? 1 : 0) != 0);
        messages = manager.listMails(origin, COLUMNS, 610, Order.DESCENDING, true, "social");
        TrainTest.assertTrue((String)"Category 1 should contain no email!", (messages.length == 0 ? 1 : 0) != 0);
        this.getClient().execute(new NewMailRequest(null, this.EML, -1, true));
        messages = manager.listMails(origin, COLUMNS, 610, Order.DESCENDING, true, "general");
        TrainTest.assertTrue((String)"General category should still contain only the old email!", (messages.length == 1 ? 1 : 0) != 0);
        messages = manager.listMails(origin, COLUMNS, 610, Order.DESCENDING, true, "social");
        TrainTest.assertTrue((String)"Category 1 should now contain the new mail!", (messages.length == 1 ? 1 : 0) != 0);
    }

    public void testReorganize() throws Exception {
        MailTestManager manager = new MailTestManager(this.client, false);
        this.getClient().execute(new NewMailRequest(this.getInboxFolder(), this.EML, -1, true));
        String origin = this.values.getInboxFolder();
        manager.trainCategory("social", true, false, this.getSendAddress());
        MailMessage[] messages = manager.listMails(origin, COLUMNS, 610, Order.DESCENDING, true, "general");
        TrainTest.assertTrue((String)"General category should contain no mails now!", (messages.length == 0 ? 1 : 0) != 0);
        messages = manager.listMails(origin, COLUMNS, 610, Order.DESCENDING, true, "social");
        TrainTest.assertTrue((String)"Category 1 should contain the mail now!", (messages.length == 1 ? 1 : 0) != 0);
    }

    public void testDuplicateTrain() throws Exception {
        MailTestManager manager = new MailTestManager(this.client, false);
        this.getClient().execute(new NewMailRequest(this.getInboxFolder(), this.EML, -1, true));
        String origin = this.values.getInboxFolder();
        manager.trainCategory("social", false, true, this.getSendAddress());
        manager.trainCategory("promotion", false, true, this.getSendAddress());
        MailMessage[] messages = manager.listMails(origin, COLUMNS, 610, Order.DESCENDING, true, "general");
        TrainTest.assertTrue((String)"General category should still contain the old email!", (messages.length == 1 ? 1 : 0) != 0);
        messages = manager.listMails(origin, COLUMNS, 610, Order.DESCENDING, true, "social");
        TrainTest.assertTrue((String)"Category 1 should contain no email!", (messages.length == 0 ? 1 : 0) != 0);
        messages = manager.listMails(origin, COLUMNS, 610, Order.DESCENDING, true, "promotion");
        TrainTest.assertTrue((String)"Category 2 should contain no email!", (messages.length == 0 ? 1 : 0) != 0);
        this.getClient().execute(new NewMailRequest(null, this.EML, -1, true));
        messages = manager.listMails(origin, COLUMNS, 610, Order.DESCENDING, true, "general");
        TrainTest.assertTrue((String)"General category should still contain only the old email!", (messages.length == 1 ? 1 : 0) != 0);
        messages = manager.listMails(origin, COLUMNS, 610, Order.DESCENDING, true, "social");
        TrainTest.assertTrue((String)"Category 1 should contain no email!", (messages.length == 0 ? 1 : 0) != 0);
        messages = manager.listMails(origin, COLUMNS, 610, Order.DESCENDING, true, "promotion");
        TrainTest.assertTrue((String)"Category 2 should contain the new mail!", (messages.length == 1 ? 1 : 0) != 0);
    }
}

