/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail.categories;

import com.openexchange.ajax.mail.MailTestManager;
import com.openexchange.ajax.mail.TestMail;
import com.openexchange.ajax.mail.actions.NewMailRequest;
import com.openexchange.ajax.mail.categories.AbstractMailCategoriesTest;
import com.openexchange.exception.OXException;
import java.io.IOException;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class MoveTest
extends AbstractMailCategoriesTest {
    public MoveTest(String name) throws OXException, IOException, JSONException {
        super(name);
    }

    public void testShouldMoveToAnotherCategory() throws OXException, IOException, SAXException, JSONException {
        MailTestManager manager = new MailTestManager(this.client, false);
        this.getClient().execute(new NewMailRequest(this.getInboxFolder(), this.EML, -1, true));
        String origin = this.values.getInboxFolder();
        TestMail myMail = new TestMail(this.getFirstMailInFolder(origin));
        String oldID = myMail.getId();
        manager.moveToCategory(myMail, "social");
        TestMail testMail = manager.get(origin, oldID);
        MoveTest.assertTrue((String)"Should produce no errors when getting moved e-mail", (!manager.getLastResponse().hasError() ? 1 : 0) != 0);
        MoveTest.assertTrue((String)"Should produce no conflicts when getting moved e-mail", (!manager.getLastResponse().hasConflicts() ? 1 : 0) != 0);
        MoveTest.assertTrue((String)"Move operation failed. Mail does not contain the correct user flag.", (boolean)testMail.getUserFlags().contains("$social"));
    }

    public void testShouldNotMoveToNonExistentCategory() throws OXException, IOException, SAXException, JSONException {
        MailTestManager manager = new MailTestManager(this.client, false);
        this.getClient().execute(new NewMailRequest(this.getInboxFolder(), this.EML, -1, true));
        String origin = this.values.getInboxFolder();
        TestMail myMail = new TestMail(this.getFirstMailInFolder(origin));
        String oldID = myMail.getId();
        manager.moveToCategory(myMail, "somebadcategoryidentifier");
        MoveTest.assertTrue((String)"Should produce errors when moving e-mail", (!manager.getLastResponse().hasError() ? 1 : 0) != 0);
        TestMail testMail = manager.get(origin, oldID);
        MoveTest.assertTrue((String)"Should produce no errors when getting moved e-mail", (!manager.getLastResponse().hasError() ? 1 : 0) != 0);
        MoveTest.assertTrue((String)"Should produce no conflicts when getting moved e-mail", (!manager.getLastResponse().hasConflicts() ? 1 : 0) != 0);
        MoveTest.assertTrue((String)"Mail shouldn't contain any user flags.", (testMail.getUserFlags().size() == 0 ? 1 : 0) != 0);
    }
}

