/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.CommonAllResponse;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.mime.dataobjects.MimeMailMessage;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.json.JSONArray;
import org.json.JSONException;

public class SearchResponse
extends CommonAllResponse {
    protected SearchResponse(Response response) {
        super(response);
    }

    public MailMessage[] getMailMessages(int[] columns) throws JSONException, AddressException {
        JSONArray objectsArray = (JSONArray)this.getData();
        MailMessage[] messages = new MailMessage[objectsArray.length()];
        for (int i = 0; i < objectsArray.length(); ++i) {
            MailMessage message;
            JSONArray oneMailAsArray = objectsArray.getJSONArray(i);
            messages[i] = message = this.parse(oneMailAsArray, columns);
        }
        return messages;
    }

    private MailMessage parse(JSONArray mailAsArray, int[] columns) throws JSONException, AddressException {
        MimeMailMessage message = new MimeMailMessage();
        for (int i = 0; i < mailAsArray.length() && i < columns.length; ++i) {
            if (columns[i] == 600) {
                message.setMailId((String)mailAsArray.get(i));
                continue;
            }
            if (columns[i] == 601) {
                message.setFolder((String)mailAsArray.get(i));
                continue;
            }
            if (columns[i] == 602) {
                message.setHasAttachment(((Boolean)mailAsArray.get(i)).booleanValue());
                continue;
            }
            if (columns[i] == 603) {
                this.handleInnerArrays(mailAsArray, message, i, "from");
                continue;
            }
            if (columns[i] == 604) {
                this.handleInnerArrays(mailAsArray, message, i, "to");
                continue;
            }
            if (columns[i] == 605) {
                this.handleInnerArrays(mailAsArray, message, i, "cc");
                continue;
            }
            if (columns[i] == 606) {
                this.handleInnerArrays(mailAsArray, message, i, "bcc");
                continue;
            }
            if (columns[i] == 607) {
                message.setSubject((String)mailAsArray.get(i));
                continue;
            }
            if (columns[i] != 608) continue;
            message.setSize((long)((Integer)mailAsArray.get(i)).intValue());
        }
        return message;
    }

    private void handleInnerArrays(JSONArray mailAsArray, MimeMailMessage message, int i, String type) throws JSONException, AddressException {
        JSONArray innerArray = (JSONArray)mailAsArray.get(i);
        for (int a = 0; a < innerArray.length(); ++a) {
            JSONArray secondInnerArray = (JSONArray)innerArray.get(a);
            for (int x = 0; x < secondInnerArray.length(); ++x) {
                String string = "";
                if (null == secondInnerArray.getString(x) || "null".equals(secondInnerArray.getString(x)) || !(string = secondInnerArray.getString(x)).contains("@")) continue;
                if (type.equals("from")) {
                    message.addFrom(new InternetAddress(string));
                    continue;
                }
                if (type.equals("to")) {
                    message.addTo(new InternetAddress(string));
                    continue;
                }
                if (type.equals("cc")) {
                    message.addCc(new InternetAddress(string));
                    continue;
                }
                if (!type.equals("bcc")) continue;
                message.addBcc(new InternetAddress(string));
            }
        }
    }
}

