/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.mail.actions.AbstractMailCategoriesRequest;
import com.openexchange.ajax.mail.actions.MoveMailToCategoryResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MoveMailToCategoryRequest
extends AbstractMailCategoriesRequest<MoveMailToCategoryResponse> {
    private static final String PARAMETER_CATEGORY_ID = "category_id";
    private static final String ACTION_MOVE = "move";
    private final String categoryId;
    private List<JSONObject> body;

    public MoveMailToCategoryRequest(String categoryId) {
        this.categoryId = categoryId;
        this.body = new ArrayList<JSONObject>();
    }

    public void addMail(String id, String folder) throws JSONException {
        JSONObject obj = new JSONObject(2);
        obj.put("id", (Object)id);
        obj.put("folder_id", (Object)folder);
        this.body.add(obj);
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() throws IOException, JSONException {
        LinkedList<AJAXRequest.Parameter> list = new LinkedList<AJAXRequest.Parameter>();
        list.add(new AJAXRequest.Parameter("action", ACTION_MOVE));
        list.add(new AJAXRequest.Parameter(PARAMETER_CATEGORY_ID, this.categoryId));
        return list.toArray(new AJAXRequest.Parameter[list.size()]);
    }

    @Override
    public AbstractAJAXParser<? extends MoveMailToCategoryResponse> getParser() {
        return new AbstractAJAXParser<MoveMailToCategoryResponse>(true){

            @Override
            protected MoveMailToCategoryResponse createResponse(Response response) {
                return new MoveMailToCategoryResponse(response);
            }
        };
    }

    @Override
    public Object getBody() throws IOException, JSONException {
        return new JSONArray(this.body);
    }
}

