/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.framework.MultipleRequest;
import com.openexchange.ajax.framework.MultipleResponse;
import com.openexchange.ajax.framework.UserValues;
import com.openexchange.ajax.mail.AbstractMailTest;
import com.openexchange.ajax.mail.MailFlag;
import com.openexchange.ajax.mail.TestMails;
import com.openexchange.ajax.mail.actions.DeleteRequest;
import com.openexchange.ajax.mail.actions.GetRequest;
import com.openexchange.ajax.mail.actions.GetResponse;
import com.openexchange.ajax.mail.actions.ImportMailRequest;
import com.openexchange.ajax.mail.actions.ImportMailResponse;
import com.openexchange.configuration.MailConfig;
import com.openexchange.exception.OXException;
import com.openexchange.java.Charsets;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MultipleGetTest
extends AbstractMailTest {
    private UserValues values;
    private List<String[][]> fmids = new LinkedList<String[][]>();

    public MultipleGetTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.values = this.getClient().getValues();
    }

    @Override
    protected void tearDown() throws Exception {
        for (String[][] fmid : this.fmids) {
            this.client.execute(new DeleteRequest(fmid, true).ignoreError());
        }
        super.tearDown();
    }

    private void importMail(String emlName) throws OXException, IOException, JSONException {
        int length;
        InputStreamReader streamReader = new InputStreamReader((InputStream)new FileInputStream(new File(MailConfig.getProperty(MailConfig.Property.TEST_MAIL_DIR), emlName)), Charsets.UTF_8);
        char[] buf = new char[512];
        StringBuilder sb = new StringBuilder();
        while ((length = streamReader.read(buf)) != -1) {
            sb.append(buf, 0, length);
        }
        streamReader.close();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(TestMails.replaceAddresses(sb.toString(), this.client.getValues().getSendAddress()).getBytes(Charsets.UTF_8));
        ImportMailRequest importMailRequest = new ImportMailRequest(this.values.getInboxFolder(), MailFlag.SEEN.getValue(), inputStream);
        ImportMailResponse importResp = this.client.execute(importMailRequest);
        JSONArray json = (JSONArray)importResp.getData();
        this.fmids.add(importResp.getIds());
        int err = 0;
        for (int i = 0; i < json.length(); ++i) {
            JSONObject jo = json.getJSONObject(i);
            if (!jo.has("Error")) continue;
            ++err;
        }
        if (err != 0) {
            MultipleGetTest.fail((String)"Error importing mail");
        }
    }

    public void testMultipleGet() throws OXException, IOException, JSONException {
        this.importMail("bug36333.eml");
        this.importMail("bug36333_2.eml");
        this.importMail("bug36333_3.eml");
        LinkedList<GetRequest> reqs = new LinkedList<GetRequest>();
        for (String[][] fmid : this.fmids) {
            String[] folderAndId = fmid[0];
            String folderID = folderAndId[0];
            String mailID = folderAndId[1];
            reqs.add(new GetRequest(folderID, mailID));
        }
        GetRequest[] getRequests = reqs.toArray(new GetRequest[reqs.size()]);
        MultipleRequest multipleRequest = MultipleRequest.create(getRequests);
        MultipleResponse multipleResponse = (MultipleResponse)Executor.execute(this.getSession(), multipleRequest);
        for (GetResponse response : multipleResponse) {
            Object data = response.getData();
            MultipleGetTest.assertNotNull((Object)data);
        }
    }
}

