/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.mail.AbstractMailTest;
import com.openexchange.ajax.mail.actions.AllRequest;
import com.openexchange.ajax.mail.actions.AllResponse;
import com.openexchange.ajax.mail.actions.ClearRequest;
import com.openexchange.ajax.mail.actions.NewMailRequest;
import com.openexchange.exception.OXException;
import java.io.IOException;
import javax.mail.internet.AddressException;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class ClearTest
extends AbstractMailTest {
    private static final Logger LOG = LoggerFactory.getLogger(ClearTest.class);

    public ClearTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.clearFolder(this.getInboxFolder());
        this.clearFolder(this.getSentFolder());
        this.clearFolder(this.getTrashFolder());
    }

    @Override
    public void tearDown() throws Exception {
        this.clearFolder(this.getInboxFolder());
        this.clearFolder(this.getSentFolder());
        this.clearFolder(this.getTrashFolder());
        super.tearDown();
    }

    public void testClearingOneFolder() throws OXException, IOException, SAXException, JSONException, AddressException, OXException {
        int numOfMails = 5;
        LOG.info("Appending 5 mails to fill emptied INBOX");
        String eml = "Message-Id: <4A002517.4650.0059.1@foobar.com>\nDate: Tue, 05 May 2009 11:37:58 -0500\nFrom: " + this.getSendAddress() + "\n" + "To: " + this.getSendAddress() + "\n" + "Subject: Invitation for launch\n" + "Mime-Version: 1.0\n" + "Content-Type: text/plain; charset=\"US-ASCII\"\n" + "Content-Transfer-Encoding: 7bit\n" + "\n" + "Blah blah blah blah blah blah";
        for (int i = 0; i < 5; ++i) {
            this.getClient().execute(new NewMailRequest(this.getInboxFolder(), eml, -1, true));
            LOG.info("Sent " + (i + 1) + ". mail of " + 5);
        }
        AllResponse allR = Executor.execute(this.getSession(), new AllRequest(this.getInboxFolder(), COLUMNS_DEFAULT_LIST, 0, null, true));
        if (allR.hasError()) {
            ClearTest.fail((String)allR.getException().toString());
        }
        ClearTest.assertEquals((String)"There should be 5 messages in the folder", (int)allR.getMailMessages(COLUMNS_DEFAULT_LIST).length, (int)5);
        String[] array = new String[]{this.getInboxFolder()};
        this.getClient().execute(new ClearRequest(array));
        allR = Executor.execute(this.getSession(), new AllRequest(this.getInboxFolder(), COLUMNS_DEFAULT_LIST, 0, null, true));
        if (allR.hasError()) {
            ClearTest.fail((String)allR.getException().toString());
        }
        ClearTest.assertEquals((String)"There should be no messages in the folder", (int)allR.getMailMessages(COLUMNS_DEFAULT_LIST).length, (int)0);
    }
}

