/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.framework.UserValues;
import com.openexchange.ajax.mail.AbstractMailTest;
import com.openexchange.ajax.mail.MailFlag;
import com.openexchange.ajax.mail.TestMails;
import com.openexchange.ajax.mail.actions.AttachmentRequest;
import com.openexchange.ajax.mail.actions.AttachmentResponse;
import com.openexchange.ajax.mail.actions.DeleteRequest;
import com.openexchange.ajax.mail.actions.DeleteResponse;
import com.openexchange.ajax.mail.actions.GetRequest;
import com.openexchange.ajax.mail.actions.ImportMailRequest;
import com.openexchange.ajax.mail.actions.ImportMailResponse;
import com.openexchange.configuration.MailConfig;
import com.openexchange.exception.OXException;
import com.openexchange.java.Charsets;
import com.openexchange.java.Strings;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Bug36333Test
extends AbstractMailTest {
    private UserValues values;
    String[][] fmid;

    public Bug36333Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.values = this.getClient().getValues();
    }

    @Override
    protected void tearDown() throws Exception {
        if (null != this.fmid) {
            this.client.execute(new DeleteRequest(this.fmid, true).ignoreError());
        }
        super.tearDown();
    }

    public void testBug36333() throws OXException, IOException, JSONException {
        int length;
        InputStreamReader streamReader = new InputStreamReader((InputStream)new FileInputStream(new File(MailConfig.getProperty(MailConfig.Property.TEST_MAIL_DIR), "bug36333.eml")), "UTF-8");
        char[] buf = new char[512];
        StringBuilder sb = new StringBuilder();
        while ((length = streamReader.read(buf)) != -1) {
            sb.append(buf, 0, length);
        }
        streamReader.close();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(TestMails.replaceAddresses(sb.toString(), this.client.getValues().getSendAddress()).getBytes(Charsets.UTF_8));
        ImportMailRequest importMailRequest = new ImportMailRequest(this.values.getInboxFolder(), MailFlag.SEEN.getValue(), inputStream);
        ImportMailResponse importResp = this.client.execute(importMailRequest);
        JSONArray json = (JSONArray)importResp.getData();
        this.fmid = importResp.getIds();
        int err = 0;
        for (int i = 0; i < json.length(); ++i) {
            JSONObject jo = json.getJSONObject(i);
            if (!jo.has("Error")) continue;
            ++err;
        }
        if (err != 0) {
            Bug36333Test.fail((String)"Error importing mail");
        }
        String mailID = json.getJSONObject(0).getString("id");
        String folderID = json.getJSONObject(0).getString("folder_id");
        AbstractAJAXResponse response = Executor.execute(this.getSession(), new GetRequest(folderID, mailID, true, true));
        Object data = response.getData();
        Bug36333Test.assertNotNull((Object)data);
        JSONObject jResponse = (JSONObject)data;
        JSONArray jAttachments = jResponse.getJSONArray("body");
        Bug36333Test.assertEquals((int)4, (int)jAttachments.length());
        JSONObject jAttachment = jAttachments.getJSONObject(1);
        Bug36333Test.assertEquals((String)"application/rtf", (String)jAttachment.getJSONObject("headers").getJSONObject("content-type").getString("type"));
        response = Executor.execute(this.getSession(), new AttachmentRequest(new String[]{folderID, mailID, "2"}).setFromStructure(true));
        String strBody = ((AttachmentResponse)response).getStringBody();
        Bug36333Test.assertNotNull((Object)strBody);
        Bug36333Test.assertTrue((boolean)strBody.startsWith("{\\rtf1"));
        if (folderID != null && mailID != null) {
            DeleteResponse deleteResponse = this.client.execute(new DeleteRequest(folderID, mailID, true));
            Bug36333Test.assertNull((String)"Error deleting mail. Artifacts remain", (Object)deleteResponse.getErrorMessage());
        }
    }

    public void testBug36333_2() throws OXException, IOException, JSONException {
        int length;
        InputStreamReader streamReader = new InputStreamReader((InputStream)new FileInputStream(new File(MailConfig.getProperty(MailConfig.Property.TEST_MAIL_DIR), "bug36333_2.eml")), "UTF-8");
        char[] buf = new char[512];
        StringBuilder sb = new StringBuilder();
        while ((length = streamReader.read(buf)) != -1) {
            sb.append(buf, 0, length);
        }
        streamReader.close();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(TestMails.replaceAddresses(sb.toString(), this.client.getValues().getSendAddress()).getBytes(Charsets.UTF_8));
        ImportMailRequest importMailRequest = new ImportMailRequest(this.values.getInboxFolder(), MailFlag.SEEN.getValue(), inputStream);
        ImportMailResponse importResp = this.client.execute(importMailRequest);
        JSONArray json = (JSONArray)importResp.getData();
        this.fmid = importResp.getIds();
        int err = 0;
        for (int i = 0; i < json.length(); ++i) {
            JSONObject jo = json.getJSONObject(i);
            if (!jo.has("Error")) continue;
            ++err;
        }
        if (err != 0) {
            Bug36333Test.fail((String)"Error importing mail");
        }
        String mailID = json.getJSONObject(0).getString("id");
        String folderID = json.getJSONObject(0).getString("folder_id");
        AbstractAJAXResponse response = Executor.execute(this.getSession(), new GetRequest(folderID, mailID, true, true));
        Object data = response.getData();
        Bug36333Test.assertNotNull((Object)data);
        JSONObject jResponse = (JSONObject)data;
        JSONArray jAttachments = jResponse.getJSONArray("body");
        Bug36333Test.assertEquals((int)4, (int)jAttachments.length());
        JSONObject jAttachment = jAttachments.getJSONObject(1);
        Bug36333Test.assertEquals((String)"application/rtf", (String)jAttachment.getJSONObject("headers").getJSONObject("content-type").getString("type"));
        response = Executor.execute(this.getSession(), new AttachmentRequest(new String[]{folderID, mailID, "2"}).setFromStructure(true));
        String strBody = ((AttachmentResponse)response).getStringBody();
        Bug36333Test.assertNotNull((Object)strBody);
        Bug36333Test.assertTrue((boolean)strBody.startsWith("{\\rtf1"));
        if (folderID != null && mailID != null) {
            DeleteResponse deleteResponse = this.client.execute(new DeleteRequest(folderID, mailID, true));
            Bug36333Test.assertNull((String)"Error deleting mail. Artifacts remain", (Object)deleteResponse.getErrorMessage());
        }
    }

    public void testBug36333_3() throws OXException, IOException, JSONException {
        int length;
        InputStreamReader streamReader = new InputStreamReader((InputStream)new FileInputStream(new File(MailConfig.getProperty(MailConfig.Property.TEST_MAIL_DIR), "bug36333_3.eml")), "UTF-8");
        char[] buf = new char[512];
        StringBuilder sb = new StringBuilder();
        while ((length = streamReader.read(buf)) != -1) {
            sb.append(buf, 0, length);
        }
        streamReader.close();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(TestMails.replaceAddresses(sb.toString(), this.client.getValues().getSendAddress()).getBytes(Charsets.UTF_8));
        ImportMailRequest importMailRequest = new ImportMailRequest(this.values.getInboxFolder(), MailFlag.SEEN.getValue(), inputStream);
        ImportMailResponse importResp = this.client.execute(importMailRequest);
        JSONArray json = (JSONArray)importResp.getData();
        this.fmid = importResp.getIds();
        int err = 0;
        for (int i = 0; i < json.length(); ++i) {
            JSONObject jo = json.getJSONObject(i);
            if (!jo.has("Error")) continue;
            ++err;
        }
        if (err != 0) {
            Bug36333Test.fail((String)"Error importing mail");
        }
        String mailID = json.getJSONObject(0).getString("id");
        String folderID = json.getJSONObject(0).getString("folder_id");
        AbstractAJAXResponse response = Executor.execute(this.getSession(), new GetRequest(folderID, mailID, true, true));
        Object data = response.getData();
        Bug36333Test.assertNotNull((Object)data);
        JSONObject jResponse = (JSONObject)data;
        JSONArray jAttachments = jResponse.getJSONArray("body");
        Bug36333Test.assertEquals((int)2, (int)jAttachments.length());
        JSONObject jAttachment = jAttachments.getJSONObject(1);
        Bug36333Test.assertEquals((String)"multipart/mixed", (String)jAttachment.getJSONObject("headers").getJSONObject("content-type").getString("type"));
        response = Executor.execute(this.getSession(), new AttachmentRequest(new String[]{folderID, mailID, "2.2"}).setFromStructure(true));
        byte[] binBody = ((AttachmentResponse)response).getBinaryBody();
        Bug36333Test.assertNotNull((Object)binBody);
        String base64 = Base64.encodeBase64String((byte[])binBody);
        binBody = null;
        Bug36333Test.assertTrue((String)("Unexpected content: " + Strings.abbreviate((String)base64, (int)32)), (boolean)base64.startsWith("JVBERi0xLjUNJeLjz9MN"));
        Bug36333Test.assertTrue((String)("Unexpected content: " + base64.substring(base64.length() - 32, base64.length())), (boolean)base64.endsWith("DSUlRU9GDQ=="));
        if (folderID != null && mailID != null) {
            DeleteResponse deleteResponse = this.client.execute(new DeleteRequest(folderID, mailID, true));
            Bug36333Test.assertNull((String)"Error deleting mail. Artifacts remain", (Object)deleteResponse.getErrorMessage());
        }
    }
}

