/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.framework.UserValues;
import com.openexchange.ajax.mail.AbstractMailTest;
import com.openexchange.ajax.mail.MailFlag;
import com.openexchange.ajax.mail.TestMails;
import com.openexchange.ajax.mail.actions.DeleteRequest;
import com.openexchange.ajax.mail.actions.GetRequest;
import com.openexchange.ajax.mail.actions.GetResponse;
import com.openexchange.ajax.mail.actions.ImportMailRequest;
import com.openexchange.ajax.mail.actions.ImportMailResponse;
import com.openexchange.configuration.MailConfig;
import com.openexchange.exception.OXException;
import com.openexchange.java.Charsets;
import com.openexchange.java.Streams;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Bug32355Test
extends AbstractMailTest {
    private UserValues values;
    String[][] fmid;

    public Bug32355Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.values = this.getClient().getValues();
    }

    @Override
    protected void tearDown() throws Exception {
        if (null != this.fmid) {
            this.client.execute(new DeleteRequest(this.fmid, true).ignoreError());
        }
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug32355() throws OXException, IOException, JSONException {
        StringBuilder sb = new StringBuilder(8192);
        InputStreamReader streamReader = null;
        try {
            int read;
            streamReader = new InputStreamReader((InputStream)new FileInputStream(new File(MailConfig.getProperty(MailConfig.Property.TEST_MAIL_DIR), "mail010.eml")), "UTF-8");
            char[] buf = new char[2048];
            while ((read = streamReader.read(buf, 0, 2048)) > 0) {
                sb.append(buf, 0, read);
            }
        }
        catch (Throwable throwable) {
            Streams.close(streamReader);
            throw throwable;
        }
        Streams.close((Closeable)streamReader);
        ByteArrayInputStream inputStream = Streams.newByteArrayInputStream((byte[])TestMails.replaceAddresses(sb.toString(), this.client.getValues().getSendAddress()).getBytes(Charsets.UTF_8));
        sb = null;
        ImportMailRequest importMailRequest = new ImportMailRequest(this.values.getInboxFolder(), MailFlag.SEEN.getValue(), inputStream);
        ImportMailResponse importResp = this.client.execute(importMailRequest);
        JSONArray json = (JSONArray)importResp.getData();
        this.fmid = importResp.getIds();
        int err = 0;
        for (int i = 0; i < json.length(); ++i) {
            JSONObject jo = json.getJSONObject(i);
            if (!jo.has("Error")) continue;
            ++err;
        }
        if (err != 0) {
            Bug32355Test.fail((String)"Error importing mail");
        }
        String mailID = json.getJSONObject(0).getString("id");
        String folderID = json.getJSONObject(0).getString("folder_id");
        this.client.execute(new DeleteRequest(this.fmid, true));
        GetResponse response = this.client.execute(new GetRequest(folderID, mailID, GetRequest.View.TEXT).setUnseen(true).setFailOnError(false));
        Bug32355Test.assertTrue((String)"Expected error MSG-0032 for absent message, but wasn't.", (response.hasError() && 32 == response.getException().getCode() && "MSG".equals(response.getException().getPrefix()) ? 1 : 0) != 0);
    }
}

