/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.framework.UserValues;
import com.openexchange.ajax.mail.AbstractMailTest;
import com.openexchange.ajax.mail.MailFlag;
import com.openexchange.ajax.mail.TestMails;
import com.openexchange.ajax.mail.actions.DeleteRequest;
import com.openexchange.ajax.mail.actions.DeleteResponse;
import com.openexchange.ajax.mail.actions.GetRequest;
import com.openexchange.ajax.mail.actions.GetResponse;
import com.openexchange.ajax.mail.actions.ImportMailRequest;
import com.openexchange.ajax.mail.actions.ImportMailResponse;
import com.openexchange.configuration.MailConfig;
import com.openexchange.exception.OXException;
import com.openexchange.java.Charsets;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Bug31855Test
extends AbstractMailTest {
    private UserValues values;
    String[][] fmid;

    public Bug31855Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.values = this.getClient().getValues();
    }

    @Override
    protected void tearDown() throws Exception {
        if (null != this.fmid) {
            this.client.execute(new DeleteRequest(this.fmid, true).ignoreError());
        }
        super.tearDown();
    }

    public void testBug31855() throws OXException, IOException, JSONException {
        int length;
        InputStreamReader streamReader = new InputStreamReader((InputStream)new FileInputStream(new File(MailConfig.getProperty(MailConfig.Property.TEST_MAIL_DIR), "bug31855.eml")), "UTF-8");
        char[] buf = new char[512];
        StringBuilder sb = new StringBuilder();
        while ((length = streamReader.read(buf)) != -1) {
            sb.append(buf, 0, length);
        }
        streamReader.close();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(TestMails.replaceAddresses(sb.toString(), this.client.getValues().getSendAddress()).getBytes(Charsets.UTF_8));
        ImportMailRequest importMailRequest = new ImportMailRequest(this.values.getInboxFolder(), MailFlag.SEEN.getValue(), inputStream).setStrictParsing(false);
        ImportMailResponse importResp = this.client.execute(importMailRequest);
        JSONArray json = (JSONArray)importResp.getData();
        this.fmid = importResp.getIds();
        int err = 0;
        for (int i = 0; i < json.length(); ++i) {
            JSONObject jo = json.getJSONObject(i);
            if (!jo.has("Error")) continue;
            ++err;
        }
        if (err != 0) {
            Bug31855Test.fail((String)"Error importing mail");
        }
        String mailID = json.getJSONObject(0).getString("id");
        String folderID = json.getJSONObject(0).getString("folder_id");
        GetResponse response = Executor.execute(this.getSession(), new GetRequest(folderID, mailID));
        JSONArray array = response.getAttachments();
        Bug31855Test.assertEquals((String)"Incorrect number of attachments", (int)3, (int)array.length());
        Bug31855Test.assertEquals((String)"Incorrect content type of attachment 2", (String)"application/octet-stream", (String)array.getJSONObject(1).getString("content_type"));
        Bug31855Test.assertEquals((String)"Incorrect content type of attachment 3", (String)"application/octet-stream", (String)array.getJSONObject(2).getString("content_type"));
        if (folderID != null && mailID != null) {
            DeleteResponse deleteResponse = this.client.execute(new DeleteRequest(folderID, mailID, true));
            Bug31855Test.assertNull((String)"Error deleting mail. Artifacts remain", (Object)deleteResponse.getErrorMessage());
        }
    }
}

