/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore.test;

import com.openexchange.ajax.folder.AbstractObjectCountTest;
import com.openexchange.ajax.infostore.actions.InfostoreTestManager;
import com.openexchange.file.storage.DefaultFile;
import com.openexchange.file.storage.File;
import com.openexchange.folderstorage.Folder;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.test.FolderTestManager;
import java.util.Date;
import org.junit.Test;

public final class InfostoreObjectCountTest
extends AbstractObjectCountTest {
    public InfostoreObjectCountTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCountInPrivateInfostoreFolder_AddedOne_CountReturnsOne() throws Exception {
        FolderTestManager folderTestManager = new FolderTestManager(this.client1);
        InfostoreTestManager infostoreTestManager = new InfostoreTestManager(this.client1);
        try {
            FolderObject created = InfostoreObjectCountTest.createPrivateFolder(this.client1, folderTestManager, 8);
            Folder folder = InfostoreObjectCountTest.getFolder(this.client1, created.getObjectID(), DEFAULT_COLUMNS);
            int objectsInFolder = folder.getTotal();
            InfostoreObjectCountTest.assertEquals((String)"Wrong object count", (int)0, (int)objectsInFolder);
            File expected = this.createDocumentMetadata(folder);
            infostoreTestManager.newAction(expected);
            Folder reloaded = InfostoreObjectCountTest.getFolder(this.client1, created.getObjectID(), DEFAULT_COLUMNS);
            objectsInFolder = reloaded.getTotal();
            InfostoreObjectCountTest.assertEquals((String)"Wrong object count", (int)1, (int)objectsInFolder);
        }
        finally {
            infostoreTestManager.cleanUp();
            folderTestManager.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCountInPrivateInfostoreFolder_AddedFive_CountReturnsFive() throws Exception {
        FolderTestManager folderTestManager = new FolderTestManager(this.client1);
        InfostoreTestManager infostoreTestManager = new InfostoreTestManager(this.client1);
        try {
            FolderObject created = InfostoreObjectCountTest.createPrivateFolder(this.client1, folderTestManager, 8);
            Folder folder = InfostoreObjectCountTest.getFolder(this.client1, created.getObjectID(), DEFAULT_COLUMNS);
            InfostoreObjectCountTest.assertEquals((String)"Wrong object count", (int)0, (int)folder.getTotal());
            File expected = this.createDocumentMetadata(folder);
            infostoreTestManager.newAction(expected);
            infostoreTestManager.newAction(expected);
            infostoreTestManager.newAction(expected);
            infostoreTestManager.newAction(expected);
            infostoreTestManager.newAction(expected);
            Folder reloaded = InfostoreObjectCountTest.getFolder(this.client1, created.getObjectID(), DEFAULT_COLUMNS);
            InfostoreObjectCountTest.assertEquals((String)"Wrong object count", (int)5, (int)reloaded.getTotal());
        }
        finally {
            infostoreTestManager.cleanUp();
            folderTestManager.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCountInSharedInfostoreFolder_AddFiveFromOwner_CountReturnsFiveToOwner() throws Exception {
        InfostoreTestManager infostoreTestManager = new InfostoreTestManager(this.client1);
        FolderTestManager folderTestManager = new FolderTestManager(this.client1);
        try {
            OCLPermission permissionUser1 = new OCLPermission();
            permissionUser1.setEntity(this.client1.getValues().getUserId());
            permissionUser1.setGroupPermission(false);
            permissionUser1.setFolderAdmin(true);
            permissionUser1.setAllPermission(4, 4, 4, 4);
            OCLPermission permissionUser2 = new OCLPermission();
            permissionUser2.setEntity(this.client2.getValues().getUserId());
            permissionUser2.setGroupPermission(false);
            permissionUser2.setFolderAdmin(false);
            permissionUser2.setAllPermission(4, 2, 4, 4);
            FolderObject created = InfostoreObjectCountTest.createSharedFolder(this.client1, 8, folderTestManager, permissionUser1, permissionUser2);
            Folder folder = InfostoreObjectCountTest.getFolder(this.client1, created.getObjectID(), DEFAULT_COLUMNS);
            InfostoreObjectCountTest.assertEquals((String)"Wrong object count", (int)0, (int)folder.getTotal());
            File expected = this.createDocumentMetadata(folder);
            infostoreTestManager.newAction(expected);
            infostoreTestManager.newAction(expected);
            infostoreTestManager.newAction(expected);
            infostoreTestManager.newAction(expected);
            infostoreTestManager.newAction(expected);
            Folder reloaded = InfostoreObjectCountTest.getFolder(this.client1, created.getObjectID(), DEFAULT_COLUMNS);
            InfostoreObjectCountTest.assertEquals((String)"Wrong object count", (int)5, (int)reloaded.getTotal());
            Folder reloaded2 = InfostoreObjectCountTest.getFolder(this.client2, created.getObjectID(), DEFAULT_COLUMNS);
            InfostoreObjectCountTest.assertEquals((String)"Other client is able to see objects", (int)0, (int)reloaded2.getTotal());
        }
        finally {
            infostoreTestManager.cleanUp();
            folderTestManager.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCountInSharedInfostoreFolder_AddFiveFromUserWithPermission_CountReturnsFiveToUserWithPermission() throws Exception {
        InfostoreTestManager infostoreTestManager = new InfostoreTestManager(this.client2);
        FolderTestManager folderTestManager = new FolderTestManager(this.client1);
        try {
            OCLPermission permissionUser1 = new OCLPermission();
            permissionUser1.setEntity(this.client1.getValues().getUserId());
            permissionUser1.setGroupPermission(false);
            permissionUser1.setFolderAdmin(true);
            permissionUser1.setAllPermission(4, 2, 4, 4);
            OCLPermission permissionUser2 = new OCLPermission();
            permissionUser2.setEntity(this.client2.getValues().getUserId());
            permissionUser2.setGroupPermission(false);
            permissionUser2.setFolderAdmin(false);
            permissionUser2.setAllPermission(4, 2, 4, 4);
            FolderObject created = InfostoreObjectCountTest.createSharedFolder(this.client1, 8, folderTestManager, permissionUser1, permissionUser2);
            Folder folder = InfostoreObjectCountTest.getFolder(this.client2, created.getObjectID(), DEFAULT_COLUMNS);
            InfostoreObjectCountTest.assertEquals((String)"Wrong object count", (int)0, (int)folder.getTotal());
            File expected = this.createDocumentMetadata(folder);
            infostoreTestManager.newAction(expected);
            infostoreTestManager.newAction(expected);
            infostoreTestManager.newAction(expected);
            infostoreTestManager.newAction(expected);
            infostoreTestManager.newAction(expected);
            Folder reloaded = InfostoreObjectCountTest.getFolder(this.client2, created.getObjectID(), DEFAULT_COLUMNS);
            InfostoreObjectCountTest.assertEquals((String)"Wrong object count", (int)5, (int)reloaded.getTotal());
            Folder reloaded2 = InfostoreObjectCountTest.getFolder(this.client1, created.getObjectID(), DEFAULT_COLUMNS);
            InfostoreObjectCountTest.assertEquals((String)"Wrong object count", (int)0, (int)reloaded2.getTotal());
        }
        finally {
            infostoreTestManager.cleanUp();
            folderTestManager.cleanUp();
        }
    }

    private File createDocumentMetadata(Folder folder) {
        DefaultFile expected = new DefaultFile();
        expected.setCreated(new Date());
        expected.setFolderId(folder.getID());
        expected.setTitle("InfostoreCountTest Item");
        expected.setLastModified(new Date());
        return expected;
    }
}

