/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore.actions;

import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.infostore.actions.AbstractInfostoreRequest;
import com.openexchange.ajax.infostore.actions.NewInfostoreParser;
import com.openexchange.ajax.infostore.actions.NewInfostoreResponse;
import com.openexchange.share.notification.ShareNotificationService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class NewInfostoreRequest
extends AbstractInfostoreRequest<NewInfostoreResponse> {
    private com.openexchange.file.storage.File metadata;
    private final InputStream input;
    private ShareNotificationService.Transport notificationTransport;
    private String notificationMessage;
    private boolean tryAddVersion;

    public NewInfostoreRequest() {
        this(null, (InputStream)null);
        this.tryAddVersion = false;
    }

    public NewInfostoreRequest(com.openexchange.file.storage.File data) {
        this(data, (InputStream)null);
        this.tryAddVersion = false;
    }

    public NewInfostoreRequest(com.openexchange.file.storage.File data, boolean tryAddVersion) {
        this(data, (InputStream)null);
        this.tryAddVersion = tryAddVersion;
    }

    public NewInfostoreRequest(com.openexchange.file.storage.File data, File upload) throws FileNotFoundException {
        this(data, new FileInputStream(upload));
    }

    public NewInfostoreRequest(com.openexchange.file.storage.File data, File upload, boolean tryAddVersion) throws FileNotFoundException {
        this(data, new FileInputStream(upload));
        this.tryAddVersion = tryAddVersion;
    }

    public NewInfostoreRequest(com.openexchange.file.storage.File data, InputStream input) {
        this.metadata = data;
        this.input = input;
    }

    public void setMetadata(com.openexchange.file.storage.File metadata) {
        this.metadata = metadata;
    }

    public void setNotifyPermissionEntities(ShareNotificationService.Transport transport) {
        this.setNotifyPermissionEntities(transport, null);
    }

    public void setNotifyPermissionEntities(ShareNotificationService.Transport transport, String message) {
        this.notificationTransport = transport;
        this.notificationMessage = message;
    }

    public com.openexchange.file.storage.File getMetadata() {
        return this.metadata;
    }

    @Override
    public String getBody() throws JSONException {
        JSONObject jFile = this.prepareJFile();
        if (this.notificationTransport != null) {
            JSONObject data = new JSONObject();
            data.put("file", (Object)jFile);
            JSONObject jNotification = new JSONObject();
            jNotification.put("transport", (Object)this.notificationTransport.getID());
            jNotification.put("message", (Object)this.notificationMessage);
            data.put("notification", (Object)jNotification);
            return data.toString();
        }
        return jFile.toString();
    }

    private JSONObject prepareJFile() throws JSONException {
        JSONObject originalObject = new JSONObject(this.writeJSON(this.getMetadata()));
        JSONObject retVal = new JSONObject();
        Set set = originalObject.keySet();
        for (String string : set) {
            Object test = originalObject.get(string);
            if (test == JSONObject.NULL) continue;
            if (test instanceof JSONArray) {
                if (((JSONArray)test).length() <= 0) continue;
                retVal.put(string, test);
                continue;
            }
            retVal.put(string, test);
        }
        return retVal;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return null == this.input ? AJAXRequest.Method.PUT : AJAXRequest.Method.UPLOAD;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() throws JSONException {
        ArrayList<AJAXRequest.Parameter> tmp = new ArrayList<AJAXRequest.Parameter>(3);
        tmp.add(new AJAXRequest.Parameter("action", "new"));
        tmp.add(new AJAXRequest.Parameter("try_add_version", this.tryAddVersion));
        if (null != this.input) {
            tmp.add(new AJAXRequest.FieldParameter("json", this.getBody()));
            tmp.add(new AJAXRequest.FileParameter("file", this.metadata.getFileName(), this.input, this.metadata.getFileMIMEType()));
        }
        return tmp.toArray(new AJAXRequest.Parameter[tmp.size()]);
    }

    public NewInfostoreParser getParser() {
        return new NewInfostoreParser(this.getFailOnError(), null != this.input);
    }
}

