/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.framework.Params;
import com.openexchange.ajax.infostore.actions.AbstractInfostoreRequest;
import com.openexchange.ajax.infostore.actions.GetDocumentResponse;
import java.io.IOException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.json.JSONException;

public class GetDocumentRequest
extends AbstractInfostoreRequest<GetDocumentResponse> {
    private final String id;
    private final String folder;
    private final String version;
    private AJAXRequest.Parameter[] additionalParameters;

    public GetDocumentRequest(String folder, String id, String version) {
        this.folder = folder;
        this.id = id;
        this.version = version;
    }

    public GetDocumentRequest(String folder, String id) {
        this(folder, id, null);
    }

    public void setAdditionalParameters(AJAXRequest.Parameter ... additionalParameters) {
        this.additionalParameters = additionalParameters;
    }

    @Override
    public Object getBody() throws JSONException {
        return null;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.GET;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        Params params = new Params("action", "document", "id", this.id, "folder", this.folder);
        if (null != this.version) {
            params.add("version", this.version);
        }
        if (null != this.additionalParameters) {
            params.add(this.additionalParameters);
        }
        return params.toArray();
    }

    @Override
    public AbstractAJAXParser<? extends GetDocumentResponse> getParser() {
        return new GetDocumentParser(this.getFailOnError());
    }

    private static class GetDocumentParser
    extends AbstractAJAXParser<GetDocumentResponse> {
        private HttpResponse httpResponse;
        private int statusCode;
        private String reasonPhrase;
        private final boolean failOnError;

        protected GetDocumentParser(boolean failOnError) {
            super(failOnError);
            this.failOnError = failOnError;
        }

        @Override
        protected GetDocumentResponse createResponse(Response response) throws JSONException {
            return new GetDocumentResponse(this.httpResponse);
        }

        @Override
        protected Response getResponse(String body) throws JSONException {
            throw new JSONException("Method not supported when parsing redirect responses.");
        }

        @Override
        public String checkResponse(HttpResponse resp, HttpRequest request) throws ParseException, IOException {
            this.statusCode = resp.getStatusLine().getStatusCode();
            this.reasonPhrase = resp.getStatusLine().getReasonPhrase();
            this.httpResponse = resp;
            if (this.failOnError) {
                GetDocumentParser.assertEquals((String)"Response code is not okay.", (long)200L, (long)this.statusCode);
            } else if (this.statusCode >= 400) {
                return Integer.toString(this.statusCode) + (null == this.reasonPhrase ? "" : this.reasonPhrase);
            }
            return null;
        }

        @Override
        public GetDocumentResponse parse(String body) throws JSONException {
            return new GetDocumentResponse(this.httpResponse);
        }
    }
}

