/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore.actions;

import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.infostore.actions.AbstractInfostoreRequest;
import com.openexchange.ajax.infostore.actions.CopyInfostoreParser;
import com.openexchange.ajax.infostore.actions.CopyInfostoreResponse;
import com.openexchange.file.storage.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CopyInfostoreRequest
extends AbstractInfostoreRequest<CopyInfostoreResponse> {
    private String id;
    private String folderId;
    private File metadata;
    private String version;

    public CopyInfostoreRequest(String id, String folderId, File file) {
        this(id, folderId, file, null);
    }

    public CopyInfostoreRequest(String id, String folderId, File file, String version) {
        this.id = id;
        this.folderId = folderId;
        this.metadata = file;
        this.version = version;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() throws IOException, JSONException {
        ArrayList<AJAXRequest.Parameter> tmp = new ArrayList<AJAXRequest.Parameter>(4);
        tmp.add(new AJAXRequest.Parameter("action", "copy"));
        tmp.add(new AJAXRequest.Parameter("id", this.id));
        tmp.add(new AJAXRequest.Parameter("folder", this.folderId));
        tmp.add(new AJAXRequest.Parameter("timestamp", new Date()));
        if (this.version != null) {
            tmp.add(new AJAXRequest.Parameter("version", this.version));
        }
        return tmp.toArray(new AJAXRequest.Parameter[tmp.size()]);
    }

    @Override
    public AbstractAJAXParser<? extends CopyInfostoreResponse> getParser() {
        return new CopyInfostoreParser(this.getFailOnError());
    }

    @Override
    public String getBody() throws JSONException {
        JSONObject jFile = this.prepareJFile();
        return jFile.toString();
    }

    public void setMetadata(File metadata) {
        this.metadata = metadata;
    }

    public File getMetadata() {
        return this.metadata;
    }

    private JSONObject prepareJFile() throws JSONException {
        JSONObject originalObject = new JSONObject(this.writeJSON(this.getMetadata()));
        JSONObject retVal = new JSONObject();
        Set set = originalObject.keySet();
        for (String string : set) {
            Object test = originalObject.get(string);
            if (test == JSONObject.NULL) continue;
            if (test instanceof JSONArray) {
                if (((JSONArray)test).length() <= 0) continue;
                retVal.put(string, test);
                continue;
            }
            retVal.put(string, test);
        }
        return retVal;
    }
}

