/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore;

import com.openexchange.ajax.InfostoreAJAXTest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.infostore.actions.DeleteInfostoreRequest;
import com.openexchange.ajax.infostore.actions.DeleteInfostoreResponse;
import com.openexchange.ajax.infostore.actions.GetInfostoreRequest;
import com.openexchange.ajax.infostore.actions.NewInfostoreRequest;
import com.openexchange.ajax.infostore.actions.NewInfostoreResponse;
import com.openexchange.file.storage.DefaultFile;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Test;

public class DeleteMultipleFilesTest
extends InfostoreAJAXTest {
    private AJAXClient client;
    private List<String> itemIds;
    private List<String> folderIds;

    public DeleteMultipleFilesTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client = new AJAXClient(AJAXClient.User.User1);
        this.itemIds = new ArrayList<String>();
        this.folderIds = new ArrayList<String>();
        File f1 = File.createTempFile("file1", "txt");
        this.writeBytes("Hello World", f1);
        DefaultFile data1 = new DefaultFile();
        data1.setFileName(f1.getName());
        data1.setFolderId(String.valueOf(this.client.getValues().getPrivateInfostoreFolder()));
        data1.setCreated(new Date());
        NewInfostoreRequest newReq1 = new NewInfostoreRequest((com.openexchange.file.storage.File)data1, f1);
        NewInfostoreResponse newRes1 = this.client.execute(newReq1);
        this.itemIds.add(newRes1.getID());
        this.folderIds.add(data1.getFolderId());
        File f2 = File.createTempFile("file2", "txt");
        this.writeBytes("Hello World2", f2);
        DefaultFile data2 = new DefaultFile();
        data2.setFileName(f2.getName());
        data2.setFolderId(String.valueOf(this.client.getValues().getPrivateInfostoreFolder()));
        data2.setCreated(new Date());
        NewInfostoreRequest newReq2 = new NewInfostoreRequest((com.openexchange.file.storage.File)data2, f2);
        NewInfostoreResponse newRes2 = this.client.execute(newReq2);
        this.itemIds.add(newRes2.getID());
        this.folderIds.add(data2.getFolderId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBytes(String string, File ods) {
        try (PrintWriter p = null;){
            p = new PrintWriter(new FileWriter(ods));
            p.write(string);
        }
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testDeleteMultipleFiles() throws Exception {
        GetInfostoreRequest get = new GetInfostoreRequest(this.itemIds.get(0));
        get.setFailOnError(true);
        Date lastModified = this.client.execute(get).getTimestamp();
        get = new GetInfostoreRequest(this.itemIds.get(1));
        get.setFailOnError(true);
        Date tmp = this.client.execute(get).getTimestamp();
        lastModified = lastModified.before(tmp) ? tmp : lastModified;
        DeleteInfostoreRequest delReq = new DeleteInfostoreRequest(this.itemIds, this.folderIds, lastModified);
        DeleteInfostoreResponse delRes = this.client.execute(delReq);
        JSONArray json = (JSONArray)delRes.getData();
        int len = json.length();
        for (int i = 0; i < len; ++i) {
            JSONObject jObject = json.getJSONObject(i);
            DeleteMultipleFilesTest.assertFalse((String)("Delete failed: " + delRes.getResponse().toString()), (boolean)this.itemIds.contains(jObject.getString("id")));
        }
    }
}

