/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.importexport;

import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.recurrence.ManagedAppointmentTest;
import com.openexchange.ajax.importexport.actions.ICalImportRequest;
import com.openexchange.ajax.importexport.actions.ICalImportResponse;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.importexport.ImportResult;
import java.util.Calendar;
import java.util.TimeZone;

public class Bug20498Test_ReminderJumpsAnHour
extends ManagedAppointmentTest {
    public String ical = "BEGIN:VCALENDAR\nPRODID:Strato Communicator 3.5\nVERSION:2.0\nCALSCALE:GREGORIAN\nBEGIN:VTIMEZONE\nTZID:Europe/Berlin\nX-LIC-LOCATION:Europe/Berlin\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0200\nTZNAME:CEST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0100\nTZNAME:CET\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nBEGIN:VEVENT\nDTSTAMP:20110930T140717Z\nSUMMARY:Geburtstag: Vorname Nachname (01.11.1971)\nCLASS:PUBLIC\nLAST-MODIFIED:20110930T135935Z\nDTEND;TZID=Europe/Berlin:20111102\nCREATED:20110930T135935Z\nDTSTART;TZID=Europe/Berlin:20111101\nRRULE:FREQ=YEARLY;INTERVAL=1\nBEGIN:VALARM\nACTION:DISPLAY\nTRIGGER:-P2W\nDESCRIPTION:Vorname Nachname\nEND:VALARM\nTRANSP:OPAQUE\nEND:VEVENT\nEND:VCALENDAR";

    public Bug20498Test_ReminderJumpsAnHour(String name) {
        super(name);
    }

    public void testReminderTwoWeeksBefore() throws Exception {
        ICalImportRequest importRequest = new ICalImportRequest(this.folder.getObjectID(), this.ical);
        ICalImportResponse importResponse = this.getClient().execute(importRequest);
        ImportResult[] imports = importResponse.getImports();
        Bug20498Test_ReminderJumpsAnHour.assertEquals((int)1, (int)imports.length);
        int id = Integer.parseInt(imports[0].getObjectId());
        TimeZone tz = this.getClient().getValues().getTimeZone();
        Appointment actual = this.getClient().execute(new GetRequest(this.folder.getObjectID(), id)).getAppointment(tz);
        Calendar alarm = Calendar.getInstance(TimeZone.getTimeZone(actual.getTimezone()));
        alarm.setTime(actual.getStartDate());
        alarm.add(6, -14);
        Bug20498Test_ReminderJumpsAnHour.assertEquals((String)"Wrong alarm value.", (long)((actual.getStartDate().getTime() - alarm.getTimeInMillis()) / 60000L), (long)actual.getAlarm());
    }

    public void testReminderFourDaysBefore() throws Exception {
        ICalImportRequest importRequest = new ICalImportRequest(this.folder.getObjectID(), this.ical.replace("-P2W", "-P4D"));
        ICalImportResponse importResponse = this.getClient().execute(importRequest);
        ImportResult[] imports = importResponse.getImports();
        Bug20498Test_ReminderJumpsAnHour.assertEquals((int)1, (int)imports.length);
        int id = Integer.parseInt(imports[0].getObjectId());
        TimeZone tz = this.getClient().getValues().getTimeZone();
        Appointment actual = this.getClient().execute(new GetRequest(this.folder.getObjectID(), id)).getAppointment(tz);
        Calendar alarm = Calendar.getInstance(TimeZone.getTimeZone(actual.getTimezone()));
        alarm.setTime(actual.getStartDate());
        alarm.add(6, -4);
        Bug20498Test_ReminderJumpsAnHour.assertEquals((String)"Wrong alarm value.", (long)((actual.getStartDate().getTime() - alarm.getTimeInMillis()) / 60000L), (long)actual.getAlarm());
    }

    public void testReminderEightMinutesBefore() throws Exception {
        ICalImportRequest importRequest = new ICalImportRequest(this.folder.getObjectID(), this.ical.replace("-P2W", "-P8M"));
        ICalImportResponse importResponse = this.getClient().execute(importRequest);
        ImportResult[] imports = importResponse.getImports();
        Bug20498Test_ReminderJumpsAnHour.assertEquals((int)1, (int)imports.length);
        int id = Integer.parseInt(imports[0].getObjectId());
        TimeZone tz = this.getClient().getValues().getTimeZone();
        Appointment actual = this.getClient().execute(new GetRequest(this.folder.getObjectID(), id)).getAppointment(tz);
        Bug20498Test_ReminderJumpsAnHour.assertEquals((int)8, (int)actual.getAlarm());
    }

    public void testReminderEightMinutesBeforeCorrectly() throws Exception {
        ICalImportRequest importRequest = new ICalImportRequest(this.folder.getObjectID(), this.ical.replace("-P2W", "-PT8M"));
        ICalImportResponse importResponse = this.getClient().execute(importRequest);
        ImportResult[] imports = importResponse.getImports();
        Bug20498Test_ReminderJumpsAnHour.assertEquals((int)1, (int)imports.length);
        int id = Integer.parseInt(imports[0].getObjectId());
        TimeZone tz = this.getClient().getValues().getTimeZone();
        Appointment actual = this.getClient().execute(new GetRequest(this.folder.getObjectID(), id)).getAppointment(tz);
        Bug20498Test_ReminderJumpsAnHour.assertEquals((int)8, (int)actual.getAlarm());
    }

    public void testReminderSixteenHoursBefore() throws Exception {
        ICalImportRequest importRequest = new ICalImportRequest(this.folder.getObjectID(), this.ical.replace("-P2W", "-P16H"));
        ICalImportResponse importResponse = this.getClient().execute(importRequest);
        ImportResult[] imports = importResponse.getImports();
        Bug20498Test_ReminderJumpsAnHour.assertEquals((int)1, (int)imports.length);
        int id = Integer.parseInt(imports[0].getObjectId());
        TimeZone tz = this.getClient().getValues().getTimeZone();
        Appointment actual = this.getClient().execute(new GetRequest(this.folder.getObjectID(), id)).getAppointment(tz);
        Bug20498Test_ReminderJumpsAnHour.assertEquals((int)960, (int)actual.getAlarm());
    }

    public void testReminderSixteenHoursBeforeCorrectly() throws Exception {
        ICalImportRequest importRequest = new ICalImportRequest(this.folder.getObjectID(), this.ical.replace("-P2W", "-PT16H"));
        ICalImportResponse importResponse = this.getClient().execute(importRequest);
        ImportResult[] imports = importResponse.getImports();
        Bug20498Test_ReminderJumpsAnHour.assertEquals((int)1, (int)imports.length);
        int id = Integer.parseInt(imports[0].getObjectId());
        TimeZone tz = this.getClient().getValues().getTimeZone();
        Appointment actual = this.getClient().execute(new GetRequest(this.folder.getObjectID(), id)).getAppointment(tz);
        Bug20498Test_ReminderJumpsAnHour.assertEquals((int)960, (int)actual.getAlarm());
    }

    public void testReminderFourWeeksBefore() throws Exception {
        ICalImportRequest importRequest = new ICalImportRequest(this.folder.getObjectID(), this.ical.replace("-P2W", "-P4W"));
        ICalImportResponse importResponse = this.getClient().execute(importRequest);
        ImportResult[] imports = importResponse.getImports();
        Bug20498Test_ReminderJumpsAnHour.assertEquals((int)1, (int)imports.length);
        int id = Integer.parseInt(imports[0].getObjectId());
        TimeZone tz = this.getClient().getValues().getTimeZone();
        Appointment actual = this.getClient().execute(new GetRequest(this.folder.getObjectID(), id)).getAppointment(tz);
        Calendar alarm = Calendar.getInstance(TimeZone.getTimeZone(actual.getTimezone()));
        alarm.setTime(actual.getStartDate());
        alarm.add(6, -28);
        Bug20498Test_ReminderJumpsAnHour.assertEquals((String)"Wrong alarm value.", (long)((actual.getStartDate().getTime() - alarm.getTimeInMillis()) / 60000L), (long)actual.getAlarm());
    }

    public void testReminderWithCombinedTimeBefore() throws Exception {
        ICalImportRequest importRequest = new ICalImportRequest(this.folder.getObjectID(), this.ical.replace("-P2W", "-PT1W2D3H4M5S"));
        ICalImportResponse importResponse = this.getClient().execute(importRequest);
        ImportResult[] imports = importResponse.getImports();
        Bug20498Test_ReminderJumpsAnHour.assertEquals((int)1, (int)imports.length);
        int id = Integer.parseInt(imports[0].getObjectId());
        TimeZone tz = this.getClient().getValues().getTimeZone();
        Appointment actual = this.getClient().execute(new GetRequest(this.folder.getObjectID(), id)).getAppointment(tz);
        Calendar alarm = Calendar.getInstance(TimeZone.getTimeZone(actual.getTimezone()));
        alarm.setTime(actual.getStartDate());
        alarm.add(6, -9);
        alarm.add(11, -3);
        alarm.add(12, -4);
        Bug20498Test_ReminderJumpsAnHour.assertEquals((String)"Wrong alarm value.", (long)((actual.getStartDate().getTime() - alarm.getTimeInMillis()) / 60000L), (long)actual.getAlarm());
    }

    public void testBiggerThanOxSupposedlyAllows() throws Exception {
        ICalImportRequest importRequest = new ICalImportRequest(this.folder.getObjectID(), this.ical.replace("-P2W", "-PT6W"));
        ICalImportResponse importResponse = this.getClient().execute(importRequest);
        ImportResult[] imports = importResponse.getImports();
        Bug20498Test_ReminderJumpsAnHour.assertEquals((int)1, (int)imports.length);
        int id = Integer.parseInt(imports[0].getObjectId());
        TimeZone tz = this.getClient().getValues().getTimeZone();
        Appointment actual = this.getClient().execute(new GetRequest(this.folder.getObjectID(), id)).getAppointment(tz);
        Calendar alarm = Calendar.getInstance(TimeZone.getTimeZone(actual.getTimezone()));
        alarm.setTime(actual.getStartDate());
        alarm.add(6, -42);
        Bug20498Test_ReminderJumpsAnHour.assertEquals((String)"Wrong alarm value.", (long)((actual.getStartDate().getTime() - alarm.getTimeInMillis()) / 60000L), (long)actual.getAlarm());
    }
}

