/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.framework;

import com.openexchange.ajax.fields.OrderFields;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractColumnsParser;
import com.openexchange.ajax.framework.AbstractColumnsResponse;
import com.openexchange.ajax.framework.Header;
import com.openexchange.groupware.search.Order;
import com.openexchange.java.Strings;
import java.util.ArrayList;

public abstract class AbstractAllRequest<T extends AbstractColumnsResponse>
implements AJAXRequest<T> {
    protected final String servletPath;
    protected final String folderId;
    protected final int[] columns;
    protected final String alias;
    protected final int sort;
    protected final Order order;
    protected final boolean failOnError;
    protected int leftHandLimit = -1;
    protected int rightHandLimit = -1;
    protected String categoryId;

    public AbstractAllRequest(String servletPath, int folderId, int[] columns, int sort, Order order, boolean failOnError) {
        this.servletPath = servletPath;
        this.folderId = String.valueOf(folderId);
        this.columns = columns;
        this.alias = null;
        this.sort = sort;
        this.order = order;
        this.failOnError = failOnError;
    }

    public AbstractAllRequest(String servletPath, int folderId, String alias, int sort, Order order, boolean failOnError) {
        this.servletPath = servletPath;
        this.folderId = String.valueOf(folderId);
        this.columns = null;
        this.alias = alias;
        this.sort = sort;
        this.order = order;
        this.failOnError = failOnError;
    }

    public AbstractAllRequest(String servletPath, String folderPath, int[] columns, int sort, Order order, boolean failOnError) {
        this.servletPath = servletPath;
        this.folderId = folderPath;
        this.columns = columns;
        this.alias = null;
        this.sort = sort;
        this.order = order;
        this.failOnError = failOnError;
    }

    public AbstractAllRequest(String servletPath, String folderPath, String alias, int sort, Order order, boolean failOnError) {
        this.servletPath = servletPath;
        this.folderId = folderPath;
        this.columns = null;
        this.alias = alias;
        this.sort = sort;
        this.order = order;
        this.failOnError = failOnError;
    }

    @Override
    public String getServletPath() {
        return this.servletPath;
    }

    @Override
    public Header[] getHeaders() {
        return NO_HEADER;
    }

    @Override
    public Object getBody() {
        return null;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.GET;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        ArrayList<AJAXRequest.Parameter> params = new ArrayList<AJAXRequest.Parameter>();
        params.add(new AJAXRequest.Parameter("action", "all"));
        params.add(new AJAXRequest.Parameter("folder", this.folderId));
        if (this.columns != null) {
            params.add(new AJAXRequest.Parameter("columns", this.columns));
        }
        if (this.alias != null) {
            params.add(new AJAXRequest.Parameter("columns", this.alias));
        }
        if (null != this.order) {
            params.add(new AJAXRequest.Parameter("sort", this.sort));
            params.add(new AJAXRequest.Parameter("order", OrderFields.write((Order)this.order)));
        }
        if (this.validateLimit()) {
            params.add(new AJAXRequest.Parameter("left_hand_limit", this.leftHandLimit));
            params.add(new AJAXRequest.Parameter("right_hand_limit", this.rightHandLimit));
        }
        if (!Strings.isEmpty((String)this.categoryId)) {
            params.add(new AJAXRequest.Parameter("categoryid", this.categoryId));
        }
        return params.toArray(new AJAXRequest.Parameter[params.size()]);
    }

    @Override
    public abstract AbstractColumnsParser<T> getParser();

    public int[] getColumns() {
        return this.columns;
    }

    public String getAlias() {
        return this.alias;
    }

    protected boolean isFailOnError() {
        return this.failOnError;
    }

    public void setLeftHandLimit(int leftHandLimit) {
        this.leftHandLimit = leftHandLimit;
    }

    public void setRightHandLimit(int rightHandLimit) {
        this.rightHandLimit = rightHandLimit;
    }

    protected final boolean validateLimit() {
        if (this.rightHandLimit != -1 || this.leftHandLimit != -1) {
            if (this.rightHandLimit < this.leftHandLimit) {
                throw new IllegalArgumentException("right-hand index is less than left-hand index");
            }
            return true;
        }
        return false;
    }
}

