/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder.api2;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.FolderUpdatesResponse;
import com.openexchange.ajax.folder.actions.GetRequest;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.folder.actions.UpdatesRequest;
import com.openexchange.ajax.folder.api2.AbstractFolderTest;
import com.openexchange.ajax.framework.AbstractUpdatesRequest;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class UpdatesTest
extends AbstractFolderTest {
    public UpdatesTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdates() throws Throwable {
        int newId = -1;
        try {
            FolderObject fo = new FolderObject();
            fo.setParentFolderID(1);
            fo.setFolderName("testCalendarFolder" + System.currentTimeMillis());
            fo.setModule(2);
            OCLPermission oclP = new OCLPermission();
            oclP.setEntity(this.client.getValues().getUserId());
            oclP.setGroupPermission(false);
            oclP.setFolderAdmin(true);
            oclP.setAllPermission(128, 128, 128, 128);
            fo.setPermissionsAsArray(new OCLPermission[]{oclP});
            InsertRequest request = new InsertRequest((API)EnumAPI.OUTLOOK, fo);
            InsertResponse response = this.client.execute(request);
            String tmpId = (String)response.getResponse().getData();
            UpdatesTest.assertNotNull((String)"New ID must not be null!", (Object)tmpId);
            newId = Integer.parseInt(tmpId);
            fo.setObjectID(newId);
            Date timeStamp = this.client.execute(new GetRequest((API)EnumAPI.OUTLOOK, fo.getObjectID())).getTimestamp();
            fo.setLastModified(timeStamp);
            UpdatesRequest request2 = new UpdatesRequest(EnumAPI.OUTLOOK, new int[]{6, 1}, -1, null, new Date(timeStamp.getTime() - 1L));
            FolderUpdatesResponse response2 = this.client.execute(request2);
            UpdatesTest.assertNotNull((Object)response2);
            List<FolderObject> l = response2.getFolders();
            boolean found = false;
            for (FolderObject folderObject : l) {
                found |= newId == folderObject.getObjectID();
            }
            UpdatesTest.assertTrue((String)"Newly created folder not contained in action=updates response.", (boolean)found);
        }
        finally {
            if (newId > 0) {
                try {
                    DeleteRequest deleteRequest = new DeleteRequest((API)EnumAPI.OUTLOOK, newId, new Date());
                    this.client.execute(deleteRequest);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void testUpdatesAll() throws Throwable {
        UpdatesRequest request = new UpdatesRequest(EnumAPI.OX_NEW, new int[]{6}, -1, null, new Date(0L));
        FolderUpdatesResponse response = this.client.execute(request);
        UpdatesTest.assertNotNull((Object)response);
        UpdatesTest.assertFalse((String)("Error occurred: " + response.getResponse().getErrorMessage()), (boolean)response.getResponse().hasError());
    }

    public void testModifiedAndDeleted() throws Throwable {
        int numberOfFolders = 8;
        List<FolderObject> newFolders = this.createAndPersistSeveral("testFolder-" + System.currentTimeMillis(), 8);
        ArrayList<FolderObject> updatedFolders = new ArrayList<FolderObject>(2);
        ArrayList<Integer> expectUpdatedFolderIds = new ArrayList<Integer>(2);
        updatedFolders.add(newFolders.get(0));
        expectUpdatedFolderIds.add(newFolders.get(0).getObjectID());
        updatedFolders.add(newFolders.get(1));
        expectUpdatedFolderIds.add(newFolders.get(1).getObjectID());
        this.updateFolders(updatedFolders);
        ArrayList<FolderObject> deletedFolders = new ArrayList<FolderObject>(2);
        ArrayList<Integer> expectDeletedFolderIds = new ArrayList<Integer>(2);
        deletedFolders.add(newFolders.get(2));
        expectDeletedFolderIds.add(newFolders.get(2).getObjectID());
        deletedFolders.add(newFolders.get(3));
        expectDeletedFolderIds.add(newFolders.get(3).getObjectID());
        this.deleteFolders(deletedFolders);
        Date lastModified = newFolders.get(7).getLastModified();
        int[] cols = new int[]{1, 300};
        FolderUpdatesResponse modifiedFoldersResponse = this.listModifiedFolders(cols, lastModified, AbstractUpdatesRequest.Ignore.NONE);
        UpdatesTest.assertTrue((boolean)modifiedFoldersResponse.getNewOrModifiedIds().containsAll(expectUpdatedFolderIds));
        UpdatesTest.assertTrue((boolean)modifiedFoldersResponse.getDeletedIds().containsAll(expectDeletedFolderIds));
        newFolders.removeAll(deletedFolders);
        this.deleteFolders(newFolders);
    }
}

