/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder.api2;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.mail.actions.GetRequest;
import com.openexchange.ajax.mail.actions.ImportMailRequest;
import com.openexchange.ajax.mail.actions.ImportMailResponse;
import com.openexchange.ajax.mail.actions.MoveMailRequest;
import com.openexchange.ajax.mail.actions.UpdateMailResponse;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.java.Charsets;
import java.io.ByteArrayInputStream;
import java.util.Date;

public class Bug15752Test
extends AbstractAJAXSession {
    private AJAXClient client;
    private String inboxFolder;
    private String[] mailIds;
    private FolderObject testFolder;
    private static final String MAIL = "From: #ADDR#\nTo: #ADDR#\nSubject: Test for bug 15572\nMime-Version: 1.0\nContent-Type: text/plain; charset=\"UTF-8\"\nContent-Transfer-Encoding: 8bit\n\nTest for bug 15572\n\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00df\n";

    public Bug15752Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.inboxFolder = this.client.getValues().getInboxFolder();
        String mail = MAIL.replaceAll("#ADDR#", this.client.getValues().getSendAddress());
        ByteArrayInputStream mailStream = new ByteArrayInputStream(mail.getBytes(Charsets.UTF_8));
        ImportMailRequest request = new ImportMailRequest(this.inboxFolder, 0, mailStream);
        ImportMailResponse response = this.client.execute(request);
        this.mailIds = response.getIds()[0];
        this.testFolder = new FolderObject();
        this.testFolder.setModule(7);
        this.testFolder.setFolderName("testFolder4Bug15752-2-" + System.currentTimeMillis());
        this.testFolder.setFullName(this.inboxFolder + '/' + this.testFolder.getFolderName());
        InsertRequest iReq = new InsertRequest((API)EnumAPI.OUTLOOK, this.testFolder);
        InsertResponse iResp = this.client.execute(iReq);
        iResp.fillObject((DataObject)this.testFolder);
        this.testFolder.setLastModified(new Date());
        UpdateMailResponse uResp = this.client.execute(new MoveMailRequest(this.inboxFolder, this.testFolder.getFullName(), this.mailIds[1], true));
        this.mailIds = new String[]{uResp.getFolder(), uResp.getID()};
    }

    @Override
    protected void tearDown() throws Exception {
        if (null != this.mailIds) {
            this.client.execute(new com.openexchange.ajax.mail.actions.DeleteRequest(this.mailIds, true));
        }
        if (null != this.testFolder) {
            this.client.execute(new DeleteRequest((API)EnumAPI.OUTLOOK, this.testFolder));
        }
        super.tearDown();
    }

    public void testGetMailwithUnseen() throws Throwable {
        GetRequest request = new GetRequest(this.mailIds[0], this.mailIds[1], true, true);
        request.setUnseen(true);
        this.client.execute(request);
    }
}

