/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder.api2;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.GetRequest;
import com.openexchange.ajax.folder.actions.GetResponse;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import java.util.List;

public class Bug15672Test
extends AbstractAJAXSession {
    private AJAXClient client;
    private FolderObject folder;

    public Bug15672Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.folder = new FolderObject();
        this.folder.setParentFolderID(1);
        this.folder.setFolderName("Bug 15672 Test folder " + System.currentTimeMillis());
        this.folder.setModule(1);
        InsertRequest request = new InsertRequest((API)EnumAPI.OUTLOOK, this.folder);
        CommonInsertResponse response = this.client.execute(request);
        response.fillObject((DataObject)this.folder);
    }

    @Override
    protected void tearDown() throws Exception {
        DeleteRequest request = new DeleteRequest((API)EnumAPI.OUTLOOK, this.folder);
        this.client.execute(request);
        super.tearDown();
    }

    public void test4ProperPermissions() throws Throwable {
        GetRequest request = new GetRequest((API)EnumAPI.OUTLOOK, this.folder.getObjectID());
        GetResponse response = this.client.execute(request);
        FolderObject testFolder = response.getFolder();
        List permissions = testFolder.getPermissions();
        Bug15672Test.assertEquals((String)"Folder should have at least 1 defined permission.", (int)1, (int)permissions.size());
        OCLPermission permission = (OCLPermission)permissions.get(0);
        Bug15672Test.assertEquals((String)"Current user should be folder administrator.", (int)this.client.getValues().getUserId(), (int)permission.getEntity());
        Bug15672Test.assertTrue((boolean)permission.isFolderAdmin());
        Bug15672Test.assertFalse((boolean)permission.isSystem());
        Bug15672Test.assertEquals((int)128, (int)permission.getFolderPermission());
        Bug15672Test.assertEquals((int)128, (int)permission.getReadPermission());
        Bug15672Test.assertEquals((int)128, (int)permission.getWritePermission());
        Bug15672Test.assertEquals((int)128, (int)permission.getDeletePermission());
    }
}

