/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder.actions;

import com.openexchange.ajax.folder.actions.VersionsParser;
import com.openexchange.ajax.folder.actions.VersionsResponse;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.infostore.thirdparty.actions.AbstractFileRequest;
import com.openexchange.file.storage.File;
import com.openexchange.tools.URLParameter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.json.JSONException;

public class VersionsRequest
extends AbstractFileRequest<VersionsResponse> {
    private final String folderId;
    private final int[] columns;

    public VersionsRequest(String folderId, File.Field[] fields) {
        super(true);
        this.folderId = folderId;
        ArrayList<Integer> columnNumbers = new ArrayList<Integer>(fields.length);
        for (File.Field field : fields) {
            columnNumbers.add(field.getNumber());
        }
        int[] primitive = ArrayUtils.toPrimitive((Integer[])columnNumbers.toArray(new Integer[columnNumbers.size()]));
        Arrays.sort(primitive);
        this.columns = primitive;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.GET;
    }

    @Override
    public Object getBody() throws IOException, JSONException {
        return null;
    }

    public VersionsParser getParser() {
        return new VersionsParser(true, this.columns);
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() throws IOException, JSONException {
        ArrayList<AJAXRequest.Parameter> params = new ArrayList<AJAXRequest.Parameter>();
        params.add(new AJAXRequest.Parameter("action", "versions"));
        if (this.folderId != null) {
            params.add(new AJAXRequest.Parameter("id", this.folderId));
        }
        if (this.columns != null && this.columns.length > 0) {
            String colsArray2String = URLParameter.colsArray2String(this.columns);
            params.add(new AJAXRequest.Parameter("columns", colsArray2String));
        }
        return params.toArray(new AJAXRequest.Parameter[params.size()]);
    }
}

