/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.AbstractFolderRequest;
import com.openexchange.ajax.folder.actions.SubscribeResponse;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.folderstorage.FolderStorage;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SubscribeRequest
extends AbstractFolderRequest<SubscribeResponse> {
    private final String parent;
    private final boolean failOnError;
    private final List<String> folderIds;
    private final List<Boolean> flags;

    public SubscribeRequest(API api, boolean failOnError) {
        this(api, FolderStorage.ROOT_ID, failOnError);
    }

    public SubscribeRequest(API api, String parent, boolean failOnError) {
        super(api);
        this.parent = parent;
        this.failOnError = failOnError;
        this.folderIds = new ArrayList<String>(4);
        this.flags = new ArrayList<Boolean>(4);
    }

    public SubscribeRequest addFolderId(String folderId, boolean subscribe) {
        this.folderIds.add(folderId);
        this.flags.add(subscribe);
        return this;
    }

    @Override
    public Object getBody() {
        try {
            JSONArray jArray = new JSONArray();
            int size = this.folderIds.size();
            for (int i = 0; i < size; ++i) {
                JSONObject jObject = new JSONObject();
                jObject.put("id", (Object)this.folderIds.get(i));
                jObject.put("subscribe", this.flags.get(i).booleanValue());
                jArray.put((Object)jObject);
            }
            return jArray;
        }
        catch (JSONException e) {
            return new JSONArray();
        }
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    protected void addParameters(List<AJAXRequest.Parameter> params) {
        params.add(new AJAXRequest.Parameter("action", "subscribe"));
        params.add(new AJAXRequest.Parameter("parent", this.parent));
    }

    @Override
    public AbstractAJAXParser<? extends SubscribeResponse> getParser() {
        return new AbstractAJAXParser<SubscribeResponse>(this.failOnError){

            @Override
            protected SubscribeResponse createResponse(Response response) {
                return new SubscribeResponse(response);
            }
        };
    }
}

