/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder.actions;

import com.openexchange.ajax.parser.FolderParser;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.Permissions;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Parser {
    private static final Logger LOG = LoggerFactory.getLogger(Parser.class);

    private Parser() {
    }

    public static void parse(Object value, int column, FolderObject folder) throws OXException {
        switch (column) {
            case 1: {
                if (value instanceof Integer) {
                    folder.setObjectID(((Number)value).intValue());
                    break;
                }
                if (!(value instanceof String)) break;
                String valueS = (String)value;
                try {
                    folder.setObjectID(Integer.parseInt(valueS));
                }
                catch (NumberFormatException e) {
                    folder.setFullName((String)value);
                }
                break;
            }
            case 301: {
                folder.setModule(FolderParser.getModuleFromString((String)((String)value), (int)(folder.containsObjectID() ? folder.getObjectID() : -1)));
                break;
            }
            case 302: {
                folder.setType(((Integer)value).intValue());
                break;
            }
            case 300: {
                folder.setFolderName((String)value);
                break;
            }
            case 304: {
                folder.setSubfolderFlag(((Boolean)value).booleanValue());
                break;
            }
            case 308: {
                if (null != value && JSONObject.NULL != value) {
                    folder.setDefaultFolder(((Boolean)value).booleanValue());
                    break;
                }
                folder.setDefaultFolder(false);
                break;
            }
            case 2: {
                if (null == value || JSONObject.NULL == value) break;
                folder.setCreatedBy(((Number)value).intValue());
                break;
            }
            case 20: {
                if (null == value || JSONObject.NULL == value) break;
                if (value instanceof Integer) {
                    folder.setParentFolderID(((Number)value).intValue());
                    break;
                }
                if (!(value instanceof String)) break;
                try {
                    folder.setParentFolderID(Integer.valueOf((String)value).intValue());
                }
                catch (NumberFormatException valueS) {}
                break;
            }
            case 306: {
                if (null == value || JSONObject.NULL == value) break;
                JSONArray permissionsAsJSON = (JSONArray)value;
                int numberOfPermissions = permissionsAsJSON.length();
                OCLPermission[] perms = new OCLPermission[numberOfPermissions];
                for (int i = 0; i < numberOfPermissions; ++i) {
                    try {
                        JSONObject elem = permissionsAsJSON.getJSONObject(i);
                        if (!elem.has("entity")) {
                            throw OXFolderExceptionCode.MISSING_PARAMETER.create(new Object[]{"entity"});
                        }
                        int entity = elem.getInt("entity");
                        OCLPermission oclPerm = new OCLPermission();
                        oclPerm.setEntity(entity);
                        oclPerm.setFuid(folder.getObjectID());
                        if (!elem.has("bits")) {
                            throw OXFolderExceptionCode.MISSING_PARAMETER.create(new Object[]{"bits"});
                        }
                        int[] permissionBits = Permissions.parsePermissionBits((int)elem.getInt("bits"));
                        if (!oclPerm.setAllPermission(permissionBits[0], permissionBits[1], permissionBits[2], permissionBits[3])) {
                            throw OXFolderExceptionCode.INVALID_PERMISSION.create(new Object[]{permissionBits[0], permissionBits[1], permissionBits[2], permissionBits[3]});
                        }
                        oclPerm.setFolderAdmin(permissionBits[4] > 0);
                        if (!elem.has("group")) {
                            throw OXFolderExceptionCode.MISSING_PARAMETER.create(new Object[]{"group"});
                        }
                        oclPerm.setGroupPermission(elem.getBoolean("group"));
                        perms[i] = oclPerm;
                        continue;
                    }
                    catch (JSONException e1) {
                        throw new OXException((Throwable)e1);
                    }
                }
                folder.setPermissionsAsArray(perms);
                break;
            }
            case 3060: {
                if (null == value || JSONObject.NULL == value) break;
                JSONArray jsonPermissions = (JSONArray)value;
                for (int i = 0; i < jsonPermissions.length(); ++i) {
                }
                int numberOfPermissions = jsonPermissions.length();
                OCLPermission[] perms = new OCLPermission[numberOfPermissions];
                for (int i = 0; i < numberOfPermissions; ++i) {
                    try {
                        JSONObject elem = jsonPermissions.getJSONObject(i);
                        if (!elem.has("entity")) {
                            throw OXFolderExceptionCode.MISSING_PARAMETER.create(new Object[]{"entity"});
                        }
                        int entity = elem.getInt("entity");
                        OCLPermission oclPerm = new OCLPermission();
                        oclPerm.setEntity(entity);
                        oclPerm.setFuid(folder.getObjectID());
                        if (!elem.has("bits")) {
                            throw OXFolderExceptionCode.MISSING_PARAMETER.create(new Object[]{"bits"});
                        }
                        int[] permissionBits = Permissions.parsePermissionBits((int)elem.getInt("bits"));
                        if (!oclPerm.setAllPermission(permissionBits[0], permissionBits[1], permissionBits[2], permissionBits[3])) {
                            throw OXFolderExceptionCode.INVALID_PERMISSION.create(new Object[]{permissionBits[0], permissionBits[1], permissionBits[2], permissionBits[3]});
                        }
                        oclPerm.setFolderAdmin(permissionBits[4] > 0);
                        if (!elem.has("group")) {
                            throw OXFolderExceptionCode.MISSING_PARAMETER.create(new Object[]{"group"});
                        }
                        oclPerm.setGroupPermission(elem.getBoolean("group"));
                        perms[i] = oclPerm;
                        continue;
                    }
                    catch (JSONException e1) {
                        throw new OXException((Throwable)e1);
                    }
                }
                folder.setPermissionsAsArray(perms);
                break;
            }
            default: {
                LOG.error("Can't parse column: {}", (Object)column);
            }
        }
    }
}

