/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.folder.actions.GetResponseNew;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.exception.OXException;
import com.openexchange.folder.json.parser.FolderParser;
import com.openexchange.folder.json.parser.ParsedFolder;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.ContentTypeDiscoveryService;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.database.contentType.CalendarContentType;
import com.openexchange.folderstorage.database.contentType.ContactContentType;
import com.openexchange.folderstorage.database.contentType.InfostoreContentType;
import com.openexchange.folderstorage.database.contentType.TaskContentType;
import com.openexchange.folderstorage.filestorage.contentType.FileStorageContentType;
import com.openexchange.folderstorage.mail.contentType.MailContentType;
import com.openexchange.java.util.TimeZones;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class GetParserNew
extends AbstractAJAXParser<GetResponseNew>
implements ContentTypeDiscoveryService {
    private static final Map<String, ContentType> TYPES = new HashMap<String, ContentType>();

    protected GetParserNew(boolean failOnError) {
        super(failOnError);
    }

    @Override
    protected GetResponseNew createResponse(Response response) throws JSONException {
        ParsedFolder folder;
        JSONObject data;
        if (response.hasError()) {
            data = null;
            folder = null;
        } else {
            data = (JSONObject)response.getData();
            try {
                folder = new FolderParser((ContentTypeDiscoveryService)this).parseFolder(data, TimeZones.UTC);
            }
            catch (OXException e) {
                throw new IllegalStateException("Could not parse folder response.", e);
            }
        }
        return new GetResponseNew(response, data, (Folder)folder);
    }

    public ContentType getByString(String contentTypeString) {
        return TYPES.get(contentTypeString);
    }

    public ContentType getByModule(int module) {
        for (ContentType type : TYPES.values()) {
            if (type.getModule() != module) continue;
            return type;
        }
        return null;
    }

    static {
        TYPES.put(CalendarContentType.getInstance().toString(), (ContentType)CalendarContentType.getInstance());
        TYPES.put(ContactContentType.getInstance().toString(), (ContentType)ContactContentType.getInstance());
        TYPES.put(FileStorageContentType.getInstance().toString(), (ContentType)FileStorageContentType.getInstance());
        TYPES.put(InfostoreContentType.getInstance().toString(), (ContentType)InfostoreContentType.getInstance());
        TYPES.put(MailContentType.getInstance().toString(), (ContentType)MailContentType.getInstance());
        TYPES.put(TaskContentType.getInstance().toString(), (ContentType)TaskContentType.getInstance());
    }
}

