/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder;

import com.openexchange.ajax.folder.Create;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.GetRequest;
import com.openexchange.ajax.folder.actions.GetResponse;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.folder.actions.UpdateRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import java.util.HashSet;
import java.util.List;

public class Bug12393Test
extends AbstractAJAXSession {
    FolderObject subFolderObject;
    FolderObject parentFolderObject;
    int subFolderId;
    int parentFolderId;
    List<OCLPermission> originalSubFolderPermissions;

    public Bug12393Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        AJAXClient myClient = this.getClient();
        this.parentFolderObject = Create.setupPublicFolder("Bug12393Test-parentFolder", 8, myClient.getValues().getUserId());
        this.parentFolderObject.setParentFolderID(myClient.getValues().getPrivateInfostoreFolder());
        InsertRequest request = new InsertRequest((API)EnumAPI.OX_OLD, this.parentFolderObject);
        CommonInsertResponse response = myClient.execute(request);
        response.fillObject((DataObject)this.parentFolderObject);
        this.parentFolderId = this.parentFolderObject.getObjectID();
        this.subFolderObject = new FolderObject();
        this.subFolderObject.setFolderName("Bug12393Test-subFolder");
        this.subFolderObject.setType(2);
        this.subFolderObject.setParentFolderID(this.parentFolderId);
        this.subFolderObject.setModule(8);
        OCLPermission perm = new OCLPermission();
        perm.setEntity(myClient.getValues().getUserId());
        perm.setGroupPermission(false);
        perm.setFolderAdmin(true);
        perm.setAllPermission(128, 128, 128, 128);
        AJAXClient client2 = new AJAXClient(AJAXClient.User.User2);
        int userId2 = client2.getValues().getUserId();
        client2.logout();
        OCLPermission perm2 = new OCLPermission();
        perm2.setEntity(userId2);
        perm2.setGroupPermission(false);
        perm2.setFolderAdmin(true);
        perm2.setAllPermission(128, 128, 128, 128);
        this.subFolderObject.setPermissionsAsArray(new OCLPermission[]{perm, perm2});
        this.originalSubFolderPermissions = this.subFolderObject.getPermissions();
        request = new InsertRequest((API)EnumAPI.OX_OLD, this.subFolderObject);
        response = myClient.execute(request);
        response.fillObject((DataObject)this.subFolderObject);
        this.subFolderId = this.subFolderObject.getObjectID();
    }

    @Override
    public void tearDown() throws Exception {
        AJAXClient myClient = this.getClient();
        GetRequest getRequest = new GetRequest(EnumAPI.OX_OLD, Integer.toString(this.parentFolderId), FolderObject.ALL_COLUMNS, false);
        GetResponse getResponse = myClient.execute(getRequest);
        this.parentFolderObject = getResponse.getFolder();
        this.parentFolderObject.setLastModified(getResponse.getTimestamp());
        DeleteRequest folderDeleteRequest = new DeleteRequest((API)EnumAPI.OX_OLD, this.parentFolderObject);
        myClient.execute(folderDeleteRequest);
        super.tearDown();
    }

    public void testPermissionsOfSubfoldersRemainIntactAfterRemovalOfFolderGroupPermission() throws Exception {
        AJAXClient myClient = this.getClient();
        GetRequest getRequest = new GetRequest(EnumAPI.OX_OLD, Integer.toString(this.parentFolderId), FolderObject.ALL_COLUMNS, false);
        GetResponse getResponse = myClient.execute(getRequest);
        this.parentFolderObject = getResponse.getFolder();
        this.parentFolderObject.setLastModified(getResponse.getTimestamp());
        OCLPermission perm = new OCLPermission();
        perm.setEntity(myClient.getValues().getUserId());
        perm.setGroupPermission(false);
        perm.setFolderAdmin(true);
        perm.setAllPermission(128, 128, 128, 128);
        this.parentFolderObject.setPermissionsAsArray(new OCLPermission[]{perm});
        UpdateRequest updateRequest = new UpdateRequest((API)EnumAPI.OX_OLD, this.parentFolderObject);
        myClient.execute(updateRequest);
        getRequest = new GetRequest((API)EnumAPI.OX_OLD, Integer.toString(this.subFolderId), false);
        getResponse = myClient.execute(getRequest);
        FolderObject newSubFolderObject = getResponse.getFolder();
        HashSet<String> expectedSet = new HashSet<String>();
        for (OCLPermission permission : this.originalSubFolderPermissions) {
            expectedSet.add(permission.toString());
        }
        HashSet<String> isSet = new HashSet<String>();
        for (OCLPermission permission : newSubFolderObject.getPermissions()) {
            isSet.add(permission.toString());
        }
        Bug12393Test.assertEquals((String)"The permissions of the subfolder have changed. Differing size. ", (int)expectedSet.size(), (int)isSet.size());
        expectedSet.removeAll(isSet);
        Bug12393Test.assertTrue((String)("The permissions of the subfolder have changed: " + ((Object)expectedSet).toString()), (boolean)expectedSet.isEmpty());
    }
}

