/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.find.mail;

import com.openexchange.ajax.find.AbstractFindTest;
import com.openexchange.ajax.find.PropDocument;
import com.openexchange.ajax.mail.actions.ImportMailRequest;
import com.openexchange.ajax.mail.actions.ImportMailResponse;
import com.openexchange.ajax.user.actions.GetRequest;
import com.openexchange.ajax.user.actions.GetResponse;
import com.openexchange.exception.OXException;
import com.openexchange.find.Module;
import com.openexchange.find.common.CommonFacetType;
import com.openexchange.find.facet.ActiveFacet;
import com.openexchange.find.facet.Facet;
import com.openexchange.find.facet.FacetType;
import com.openexchange.find.facet.FacetValue;
import com.openexchange.find.facet.Filter;
import com.openexchange.find.util.DisplayItems;
import com.openexchange.groupware.container.Contact;
import com.openexchange.java.Charsets;
import com.openexchange.java.util.TimeZones;
import com.openexchange.mail.utils.DateUtils;
import com.openexchange.test.ContactTestManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.json.JSONException;

public abstract class AbstractMailFindTest
extends AbstractFindTest {
    protected String defaultAddress;
    protected ContactTestManager contactManager;
    protected static final String MAIL = "From: #FROM#\nTo: #TO#\nCC: #TO#\nBCC: #TO#\nReceived: from ox.open-xchange.com;#DATE#\nDate: #DATE#\nSubject: #SUBJECT#\nDisposition-Notification-To: #FROM#\nMime-Version: 1.0\nContent-Type: text/plain; charset=\"UTF-8\"\nContent-Transfer-Encoding: 8bit\n\nContent\n#BODY#\n";

    public AbstractMailFindTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.defaultAddress = this.client.getValues().getSendAddress();
        this.contactManager = new ContactTestManager(this.client);
    }

    @Override
    protected void tearDown() throws Exception {
        this.contactManager.cleanUp();
        super.tearDown();
    }

    protected List<ActiveFacet> prepareFacets() throws OXException, IOException, JSONException {
        return this.prepareFacets(this.client.getValues().getInboxFolder());
    }

    protected List<ActiveFacet> prepareFacets(String folder) {
        LinkedList<ActiveFacet> facets = new LinkedList<ActiveFacet>();
        facets.add(AbstractMailFindTest.createActiveFacet((FacetType)CommonFacetType.FOLDER, folder, Filter.NO_FILTER));
        return facets;
    }

    protected List<Facet> autocomplete(String prefix) throws Exception {
        return this.autocomplete(Module.MAIL, prefix, this.prepareFacets());
    }

    protected List<Facet> autocomplete(String prefix, List<ActiveFacet> facets) throws Exception {
        return this.autocomplete(Module.MAIL, prefix, facets);
    }

    protected List<PropDocument> query(List<ActiveFacet> facets, int start, int size) throws Exception {
        return this.query(Module.MAIL, facets, start, size);
    }

    protected List<PropDocument> query(List<ActiveFacet> facets) throws Exception {
        return this.query(Module.MAIL, facets);
    }

    protected List<PropDocument> query(List<ActiveFacet> facets, Map<String, String> options) throws Exception {
        return this.query(Module.MAIL, facets, options);
    }

    protected List<PropDocument> query(List<ActiveFacet> facets, int[] columns) throws Exception {
        return this.query(Module.MAIL, facets, columns);
    }

    protected FacetValue detectContact(Contact contact, List<Facet> facets) throws OXException, IOException, JSONException {
        FacetValue found = AbstractMailFindTest.findByDisplayName(facets, DisplayItems.convert((Contact)contact).getDisplayName());
        return found;
    }

    protected FacetValue detectContact(List<Facet> facets) throws OXException, IOException, JSONException {
        GetRequest getRequest = new GetRequest(this.client.getValues().getUserId(), this.client.getValues().getTimeZone());
        GetResponse getResponse = this.client.execute(getRequest);
        Contact contact = getResponse.getContact();
        FacetValue found = AbstractMailFindTest.findByDisplayName(facets, DisplayItems.convert((Contact)contact).getDisplayName());
        return found;
    }

    protected Contact randomContact(String givenName, int folderId) {
        Contact contact = new Contact();
        contact.setParentFolderID(folderId);
        contact.setSurName(AbstractMailFindTest.randomUID());
        contact.setGivenName(givenName);
        contact.setDisplayName(contact.getGivenName() + " " + contact.getSurName());
        contact.setEmail1(AbstractMailFindTest.randomUID() + "@example.com");
        contact.setUid(AbstractMailFindTest.randomUID());
        return contact;
    }

    protected Contact specificContact(String givenName, String surName, String mailAddress, int folderId) {
        Contact contact = new Contact();
        contact.setParentFolderID(folderId);
        if (surName != null) {
            contact.setSurName(surName);
        }
        if (givenName != null) {
            contact.setGivenName(givenName);
        }
        contact.setEmail1(mailAddress);
        contact.setUid(AbstractMailFindTest.randomUID());
        return contact;
    }

    protected void findContactsInValues(List<Contact> contacts, List<FacetValue> values) {
        for (Contact contact : contacts) {
            boolean found = false;
            String contactDN = DisplayItems.convert((Contact)contact).getDisplayName();
            for (FacetValue value : values) {
                String valueDN = value.getDisplayItem().getDisplayName();
                if (!contactDN.equals(valueDN)) continue;
                found = true;
                break;
            }
            AbstractMailFindTest.assertTrue((String)("Did not find contact '" + contactDN + "'"), (boolean)found);
        }
    }

    protected String[][] importMails(String folder, int num, String fromHeader, String toHeader) throws OXException, IOException, JSONException {
        InputStream[] streams = new InputStream[num];
        for (int i = 0; i < num; ++i) {
            String mail = MAIL.replaceAll("#FROM#", fromHeader).replaceAll("#TO#", toHeader).replaceAll("#DATE#", DateUtils.toStringRFC822((Date)new Date(), (TimeZone)TimeZones.UTC)).replaceAll("#SUBJECT#", AbstractMailFindTest.randomUID()).replaceAll("#BODY#", AbstractMailFindTest.randomUID());
            streams[i] = new ByteArrayInputStream(mail.getBytes(Charsets.UTF_8));
        }
        ImportMailRequest request = new ImportMailRequest(folder, 0, true, true, streams);
        ImportMailResponse response = this.client.execute(request);
        return response.getIds();
    }

    protected String[][] importMail(String folder, String fromHeader, String subject, String body) throws OXException, IOException, JSONException {
        return this.importMail(folder, this.defaultAddress, fromHeader, subject, body, new Date());
    }

    protected String[][] importMail(String folder, String toHeader, String fromHeader, String subject, String body, Date received) throws OXException, IOException, JSONException {
        String mail = MAIL.replaceAll("#FROM#", fromHeader).replaceAll("#TO#", toHeader).replaceAll("#DATE#", DateUtils.toStringRFC822((Date)received, (TimeZone)TimeZones.UTC)).replaceAll("#SUBJECT#", subject).replaceAll("#BODY#", body);
        ByteArrayInputStream mailStream = new ByteArrayInputStream(mail.getBytes(Charsets.UTF_8));
        ImportMailRequest request = new ImportMailRequest(folder, 0, true, true, (InputStream[])new ByteArrayInputStream[]{mailStream});
        ImportMailResponse response = this.client.execute(request);
        return response.getIds();
    }
}

