/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.conversion;

import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.conversion.AbstractConversionTest;
import com.openexchange.ajax.conversion.actions.ConvertRequest;
import com.openexchange.ajax.conversion.actions.ConvertResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.mail.FolderAndID;
import com.openexchange.ajax.mail.contenttypes.MailContentType;
import com.openexchange.ajax.mail.netsol.actions.NetsolGetRequest;
import com.openexchange.ajax.mail.netsol.actions.NetsolGetResponse;
import com.openexchange.ajax.mail.netsol.actions.NetsolSendRequest;
import com.openexchange.ajax.mail.netsol.actions.NetsolSendResponse;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.mail.MailJSONField;
import com.openexchange.mail.MailListField;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONObject;

public class IMipImportTest
extends AbstractConversionTest {
    private AJAXClient client1;
    private AJAXClient client2;
    private String uuid;
    private String[] mailFolderAndMailID;
    private String[] mailFolderAndMailID2;
    private String sequenceId;
    private String sequenceId2;
    private int objectId;
    private int folder;

    public IMipImportTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client1 = this.getClient();
        this.client2 = new AJAXClient(AJAXClient.User.User2);
        this.uuid = UUID.randomUUID().toString();
        this.mailFolderAndMailID = this.createMail(this.client1);
        this.mailFolderAndMailID2 = this.createMail(this.client2);
        this.sequenceId = this.getSequenceIdForMail(this.client1, this.mailFolderAndMailID);
        this.sequenceId2 = this.getSequenceIdForMail(this.client2, this.mailFolderAndMailID2);
    }

    @Override
    protected void tearDown() throws Exception {
        this.client.execute(new DeleteRequest(this.objectId, this.folder, new Date(Long.MAX_VALUE)));
        super.tearDown();
    }

    public void testIMIP() throws Exception {
        String[][] folderIdFirst = this.confirm(this.client1, this.mailFolderAndMailID, this.sequenceId, 1, "Positive");
        String[][] folderIdSecond = this.confirm(this.client2, this.mailFolderAndMailID2, this.sequenceId2, 2, "Negative");
        IMipImportTest.assertEquals((String)"Wrong amount of appointments", (int)1, (int)folderIdFirst.length);
        this.folder = Integer.valueOf(folderIdFirst[0][0]);
        this.objectId = Integer.valueOf(folderIdFirst[0][1]);
        GetRequest getRequest = new GetRequest(this.folder, this.objectId);
        GetResponse getResponse = this.client.execute(getRequest);
        Appointment appointment = getResponse.getAppointment(this.client.getValues().getTimeZone());
        boolean foundFirst = false;
        boolean foundSecond = false;
        IMipImportTest.assertEquals((String)"Wrong amount of participants", (int)2, (int)appointment.getUsers().length);
        IMipImportTest.assertEquals((String)"No new objectId for update", (int)0, (int)folderIdSecond.length);
        for (UserParticipant user : appointment.getUsers()) {
            if (user.getIdentifier() == this.client1.getValues().getUserId()) {
                foundFirst = true;
                IMipImportTest.assertEquals((String)"Wrong status", (int)1, (int)user.getConfirm());
                IMipImportTest.assertEquals((String)"Wrong message", (String)"Positive", (String)user.getConfirmMessage());
                continue;
            }
            if (user.getIdentifier() != this.client2.getValues().getUserId()) continue;
            foundSecond = true;
            IMipImportTest.assertEquals((String)"Wrong status", (int)2, (int)user.getConfirm());
            IMipImportTest.assertEquals((String)"Wrong message", (String)"Negative", (String)user.getConfirmMessage());
        }
        IMipImportTest.assertTrue((String)"Missing user", (boolean)foundFirst);
        IMipImportTest.assertTrue((String)"Missing user", (boolean)foundSecond);
    }

    protected String[][] confirm(AJAXClient c, String[] folderAndId, String seq, int confirm, String message) throws Exception {
        JSONObject jsonBody = new JSONObject();
        JSONObject jsonSource = new JSONObject().put("identifier", (Object)"com.openexchange.mail.ical");
        jsonSource.put("args", (Object)new JSONArray().put((Object)new JSONObject().put("com.openexchange.mail.conversion.fullname", (Object)folderAndId[0])).put((Object)new JSONObject().put("com.openexchange.mail.conversion.mailid", (Object)folderAndId[1])).put((Object)new JSONObject().put("com.openexchange.mail.conversion.sequenceid", (Object)seq)));
        jsonBody.put("datasource", (Object)jsonSource);
        JSONObject jsonHandler = new JSONObject().put("identifier", (Object)"com.openexchange.ical");
        jsonHandler.put("args", (Object)new JSONArray().put((Object)new JSONObject().put("com.openexchange.groupware.calendar.folder", this.getPrivateCalendarFolder())).put((Object)new JSONObject().put("com.openexchange.groupware.task.folder", this.getPrivateTaskFolder())).put((Object)new JSONObject().put("com.openexchange.groupware.calendar.confirmstatus", confirm)).put((Object)new JSONObject().put("com.openexchange.groupware.calendar.confirmmessage", (Object)message)));
        jsonBody.put("datahandler", (Object)jsonHandler);
        ConvertResponse convertResponse = (ConvertResponse)((Object)Executor.execute(c.getSession(), new ConvertRequest(jsonBody, true)));
        return convertResponse.getFoldersAndIDs();
    }

    protected String[] createMail(AJAXClient c) throws Exception {
        byte[] ICAL_BYTES = ("BEGIN:VCALENDAR\n" + "VERSION:2.0\n" + "METHOD:REQUEST\n" + "BEGIN:VEVENT\n" + "ORGANIZER:" + this.client1.getValues().getSendAddress() + '\n' + "ATTENDEE;PARTSTAT=ACCEPTED;CN=Da Organiza:Mailto:" + this.client1.getValues().getSendAddress() + '\n' + "ATTENDEE;RSVP=TRUE;TYPE=INDIVIDUAL;CN=Second User:Mailto:" + this.client2.getValues().getSendAddress() + '\n' + "DTSTART;VALUE=DATE:20061221\n" + "DTEND;VALUE=DATE:20070106\n" + "SUMMARY:Weihnachtsferien\n" + "UID:" + this.uuid + '\n' + "SEQUENCE:8\n" + "DTSTAMP:20060520T163834Z\n" + "END:VEVENT\n" + "END:VCALENDAR").getBytes();
        JSONObject mail = new JSONObject();
        mail.put(MailJSONField.FROM.getKey(), (Object)c.getValues().getSendAddress());
        mail.put(MailJSONField.RECIPIENT_TO.getKey(), (Object)(this.client2.getValues().getSendAddress() + "," + this.client2.getValues().getSendAddress()));
        mail.put(MailJSONField.RECIPIENT_CC.getKey(), (Object)"");
        mail.put(MailJSONField.RECIPIENT_BCC.getKey(), (Object)"");
        mail.put(MailJSONField.SUBJECT.getKey(), (Object)"New Event");
        mail.put(MailJSONField.PRIORITY.getKey(), (Object)"3");
        JSONObject bodyObject = new JSONObject();
        bodyObject.put(MailJSONField.CONTENT_TYPE.getKey(), (Object)MailContentType.ALTERNATIVE.toString());
        bodyObject.put(MailJSONField.CONTENT.getKey(), (Object)"Mail text.<br /><br />People have been asking for support for the IMAP IDLE command for quite<br />a few years and I think I've finally figured out how to provide such<br />support safely.  The difficulty isn't in executing the command, which<br />is quite straightforward, the difficulty is in deciding how to expose<br />it to applications, and inhandling the multithreading issues that<br />arise.<br /><br />After three attempts, I've got a version that seems to work.  It passes<br />all my tests, including a multithreading test I wrote just for this<br />purpose.  So now it's time for others to try it out as well.  Below is<br />my writeup on how to use the IDLE command.  You can find the test<br />version of JavaMail (essentially an early version of JavaMail 1.4.1)<br />in the java.net Maven repository (you want the 1.4.1ea version):<br /><br />https://maven-repository.dev.java.net/nonav/repository/javax.mail/<br /><br />Note that this version is built with JDK 1.5 and thus requires JDK 1.5.<br /><br />Oh,and here's the entire list of what's fixed in this version so far:<br /><br />4107594 IMAP implementation should use the IDLE extension if available<br />6423701 Problem with using OrTerm when the protocol is IMAP<br />6431207 SMTP is adding extra CRLF to message content<br />6447295 IMAPMessage fails to return Content-Language from bodystructure<br />6447799 encoded text not decoded even when mail.mime.decodetext.strict is false<br />6447801 MimeBodyPart.writeTo reencodes data unnecessarily<br />6456422 NullPointerException in smtptransport when sending MimeMessages<br />        with no encoding<br />6456444 MimeMessages created from stream are not correctly handled<br />        with allow8bitmime<br />&lt;no id&gt; fix performance bug in base64 encoder; now even faster!");
        JSONArray attachments = new JSONArray();
        attachments.put((Object)bodyObject);
        mail.put(MailJSONField.ATTACHMENTS.getKey(), (Object)attachments);
        UnsynchronizedByteArrayInputStream in = new UnsynchronizedByteArrayInputStream(ICAL_BYTES);
        NetsolSendResponse response = Executor.execute(c.getSession(), new NetsolSendRequest(mail.toString(), (InputStream)in, "text/calendar; charset=US-ASCII", "ical.ics"));
        IMipImportTest.assertTrue((String)"Send failed", (response.getFolderAndID() != null ? 1 : 0) != 0);
        IMipImportTest.assertTrue((String)"Duration corrupt", (response.getRequestDuration() > 0L ? 1 : 0) != 0);
        String[] mailFolderAndMailID = response.getFolderAndID();
        mailFolderAndMailID[1] = this.parseMailId(mailFolderAndMailID[1]);
        return mailFolderAndMailID;
    }

    protected String getSequenceIdForMail(AJAXClient c, String[] mailFolderAndMailID) throws Exception {
        FolderAndID fai = new FolderAndID(mailFolderAndMailID[0], mailFolderAndMailID[1]);
        NetsolGetResponse resp = Executor.execute(c.getSession(), new NetsolGetRequest(fai, true));
        JSONObject mailObject = (JSONObject)resp.getData();
        JSONArray att = mailObject.getJSONArray(MailJSONField.ATTACHMENTS.getKey());
        int len = att.length();
        String sequenceId = null;
        for (int i = 0; i < len && sequenceId == null; ++i) {
            JSONObject attachObj = att.getJSONObject(i);
            if (!attachObj.getString(MailJSONField.CONTENT_TYPE.getKey()).startsWith("text/calendar")) continue;
            sequenceId = attachObj.getString(MailListField.ID.getKey());
        }
        return sequenceId;
    }
}

