/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact.action;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.test.ContactTestManager;
import com.openexchange.test.FolderTestManager;
import java.util.Date;

public class ExemplaryContactTestManagerTest
extends AbstractAJAXSession {
    private ContactTestManager contactManager;
    private AJAXClient client;
    Contact contactObject1;
    Contact contactObject2;
    private FolderTestManager folderManager;
    private FolderObject folder;

    public ExemplaryContactTestManagerTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.contactManager = new ContactTestManager(this.client);
        this.folderManager = new FolderTestManager(this.client);
        this.folder = this.folderManager.generatePublicFolder("contacts manager tests (" + new Date().getTime() + ")", 3, this.client.getValues().getPrivateContactFolder(), this.client.getValues().getUserId());
        this.folderManager.insertFolderOnServer(this.folder);
        this.contactObject1 = new Contact();
        this.contactObject1.setDisplayName("Herbert Meier");
        this.contactObject1.setEmail1("herbert.meier@example.com");
        this.contactObject1.setNote("created by ExemplaryContactTestManagerTest");
        this.contactObject1.setParentFolderID(this.folder.getObjectID());
        this.contactManager.newAction(this.contactObject1);
        this.contactObject2 = new Contact();
        this.contactObject2.setDisplayName("Herbert M\u00fcller");
        this.contactObject2.setEmail1("herbert.mueller@example.com");
        this.contactObject2.setParentFolderID(this.folder.getObjectID());
        this.contactObject2.setNote("created by ExemplaryContactTestManagerTest");
        this.contactManager.newAction(this.contactObject2);
    }

    @Override
    public void tearDown() throws Exception {
        this.contactManager.cleanUp();
        this.folderManager.cleanUp();
    }

    public void testCreatedContactsAreReturnedByGetRequest() throws Exception {
        Contact co = this.contactManager.getAction(this.contactObject1.getParentFolderID(), this.contactObject1.getObjectID());
        ExemplaryContactTestManagerTest.assertEquals((String)"The contact was not returned.", (String)co.getDisplayName(), (String)this.contactObject1.getDisplayName());
    }

    public void testCreatedContactsAppearInAllRequestForSameFolder() throws Exception {
        boolean found1 = false;
        boolean found2 = false;
        Contact[] allContacts = this.contactManager.allAction(this.folder.getObjectID());
        for (int i = 0; i < allContacts.length; ++i) {
            Contact co = allContacts[i];
            if (co.getObjectID() == this.contactObject1.getObjectID()) {
                found1 = true;
            }
            if (co.getObjectID() != this.contactObject2.getObjectID()) continue;
            found2 = true;
        }
        ExemplaryContactTestManagerTest.assertTrue((String)"First contact was not found.", (boolean)found1);
        ExemplaryContactTestManagerTest.assertTrue((String)"Second contact was not found.", (boolean)found2);
    }

    public void testCreatedContactsAppearInListRequest() throws Exception {
        boolean found1 = false;
        boolean found2 = false;
        int[] firstContact = new int[]{this.contactObject1.getParentFolderID(), this.contactObject1.getObjectID()};
        int[] secondContact = new int[]{this.contactObject2.getParentFolderID(), this.contactObject2.getObjectID()};
        Contact[] allContacts = this.contactManager.listAction(firstContact, secondContact);
        for (int i = 0; i < allContacts.length; ++i) {
            Contact co = allContacts[i];
            if (co.getObjectID() == this.contactObject1.getObjectID()) {
                found1 = true;
            }
            if (co.getObjectID() != this.contactObject2.getObjectID()) continue;
            found2 = true;
        }
        ExemplaryContactTestManagerTest.assertTrue((String)"First contact was not found.", (boolean)found1);
        ExemplaryContactTestManagerTest.assertTrue((String)"Second contact was not found.", (boolean)found2);
    }

    public void testCreatedContactsAppearInSearchRequestOverAllFolders() throws Exception {
        int i;
        boolean found1 = false;
        boolean found2 = false;
        Contact[] contacts_1 = this.contactManager.searchAction(this.contactObject1.getDisplayName(), -1);
        Contact[] contacts_2 = this.contactManager.searchAction(this.contactObject2.getDisplayName(), -1);
        for (i = 0; i < contacts_1.length; ++i) {
            if (contacts_1[i].getObjectID() != this.contactObject1.getObjectID()) continue;
            found1 = true;
        }
        for (i = 0; i < contacts_2.length; ++i) {
            if (contacts_2[i].getObjectID() != this.contactObject2.getObjectID()) continue;
            found2 = true;
        }
        ExemplaryContactTestManagerTest.assertTrue((String)"First contact was not found.", (boolean)found1);
        ExemplaryContactTestManagerTest.assertTrue((String)"Second contact was not found.", (boolean)found2);
    }

    public void testCreatedContactsAppearAsUpdatedSinceYesterday() throws Exception {
        boolean found1 = false;
        boolean found2 = false;
        Date date = new Date();
        date.setDate(date.getDate() - 1);
        Contact[] allContacts = this.contactManager.updatesAction(this.folder.getObjectID(), date);
        for (int i = 0; i < allContacts.length; ++i) {
            Contact co = allContacts[i];
            if (co.getObjectID() == this.contactObject1.getObjectID()) {
                found1 = true;
            }
            if (co.getObjectID() != this.contactObject2.getObjectID()) continue;
            found2 = true;
        }
        ExemplaryContactTestManagerTest.assertTrue((String)"First contact was not found.", (boolean)found1);
        ExemplaryContactTestManagerTest.assertTrue((String)"Second contact was not found.", (boolean)found2);
    }
}

