/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact;

import com.openexchange.ajax.config.actions.GetRequest;
import com.openexchange.ajax.config.actions.GetResponse;
import com.openexchange.ajax.config.actions.Tree;
import com.openexchange.ajax.contact.AbstractContactTest;
import com.openexchange.ajax.contact.action.SearchRequest;
import com.openexchange.ajax.contact.action.SearchResponse;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.search.ContactSearchObject;
import java.io.IOException;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class SearchTest
extends AbstractContactTest {
    public SearchTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testSearchLoginUser() throws Exception {
        Contact user = this.loadUser(this.userId);
        String displayName = user.getDisplayName();
        ContactSearchObject cso = new ContactSearchObject();
        cso.setDisplayName(displayName);
        cso.setFolders(new int[]{6});
        Contact[] contactArray = this.searchContactAdvanced(cso, new int[]{524});
        SearchTest.assertTrue((String)"contact array size is 0", (contactArray.length > 0 ? 1 : 0) != 0);
        SearchTest.assertEquals((String)"user id is not equals", (int)this.userId, (int)contactArray[0].getInternalUserId());
    }

    public void testSearchStartCharacter() throws Exception {
        Contact contactObj = new Contact();
        contactObj.setSurName("Meier");
        contactObj.setParentFolderID(this.contactFolderId);
        int objectId1 = this.insertContact(contactObj);
        int objectId2 = this.insertContact(contactObj);
        Contact[] contactArray = this.searchContact("M", this.contactFolderId, new int[]{524}, true);
        SearchTest.assertTrue((String)"contact array size < 2", (contactArray.length >= 2 ? 1 : 0) != 0);
        this.deleteContacts(true, objectId1, objectId2);
    }

    public void testSearchEmailComplete() throws Exception {
        Contact contactObj = new Contact();
        contactObj.setSurName("Mustermann");
        contactObj.setGivenName("Tom");
        contactObj.setEmail1("tom.mustermann@email.com");
        contactObj.setParentFolderID(this.contactFolderId);
        Contact contactObj2 = new Contact();
        contactObj2.setSurName("Mustermann");
        contactObj2.setGivenName("Ute");
        contactObj2.setEmail1("ute.mustermann@email.com");
        contactObj2.setParentFolderID(this.contactFolderId);
        Contact contactObj3 = new Contact();
        contactObj3.setSurName("Gloreich");
        contactObj3.setGivenName("Guenter");
        contactObj3.setEmail1("g.gloreich@email.com");
        contactObj3.setParentFolderID(this.contactFolderId);
        int objectId1 = this.insertContact(contactObj);
        int objectId2 = this.insertContact(contactObj2);
        int objectId3 = this.insertContact(contactObj3);
        ContactSearchObject cso = new ContactSearchObject();
        cso.setSurname("Must*");
        cso.setEmailAutoComplete(true);
        Contact[] contactArray = this.searchContactAdvanced(cso, new int[]{524});
        SearchTest.assertTrue((String)"contact array size >= 2", (contactArray.length >= 2 ? 1 : 0) != 0);
        cso = new ContactSearchObject();
        cso.setEmail1("*email.com");
        cso.setEmailAutoComplete(true);
        Contact[] contactArray2 = this.searchContactAdvanced(cso, new int[]{524});
        SearchTest.assertTrue((String)"contact array size >= 3", (contactArray2.length >= 3 ? 1 : 0) != 0);
        this.deleteContacts(true, objectId1, objectId2, objectId3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLastModifiedUTC() throws Exception {
        int[] cols = new int[]{1, 20, 6};
        Contact contactObj = this.createContactObject("testLastModifiedUTC");
        int objectId = this.insertContact(contactObj);
        try {
            SearchRequest searchRequest = new SearchRequest("*", this.contactFolderId, cols, true);
            SearchResponse response = Executor.execute(this.client, searchRequest);
            JSONArray arr = (JSONArray)response.getResponse().getData();
            SearchTest.assertNotNull((Object)arr);
            int size = arr.length();
            SearchTest.assertTrue((size > 0 ? 1 : 0) != 0);
            for (int i = 0; i < size; ++i) {
                JSONArray objectData = arr.optJSONArray(i);
                SearchTest.assertNotNull((Object)objectData);
                SearchTest.assertNotNull((Object)objectData.opt(2));
            }
        }
        finally {
            this.deleteContact(objectId, this.contactFolderId, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAutoCompleteWithContactCollectFolderAndGlobalAddressbook() throws Exception {
        int[] contactIds = new int[]{};
        try {
            int collectFolderId = -1;
            GetResponse getResponse = this.client.execute(new GetRequest(Tree.ContactCollectFolder));
            if (getResponse.hasValue()) {
                if (getResponse.hasInteger()) {
                    collectFolderId = getResponse.getInteger();
                    if (-1 == collectFolderId) {
                        return;
                    }
                } else if (getResponse.hasString()) {
                    SearchTest.fail((String)getResponse.getString());
                } else {
                    SearchTest.fail((String)("Response is in wrong format:" + (Object)((Object)getResponse)));
                }
            } else {
                SearchTest.fail((String)("Response has no data:" + (Object)((Object)getResponse)));
            }
            contactIds = this.insertSearchableContacts(collectFolderId);
            ContactSearchObject searchObject = new ContactSearchObject();
            searchObject.setEmail1("*e*");
            searchObject.setEmailAutoComplete(true);
            searchObject.addFolder(6);
            searchObject.addFolder(collectFolderId);
            int[] columns = new int[]{20, 1, 608};
            ArrayList<AJAXRequest.Parameter> parameters = new ArrayList<AJAXRequest.Parameter>();
            parameters.add(new AJAXRequest.Parameter("sort", 609));
            parameters.add(new AJAXRequest.Parameter("order", "ASC"));
            com.openexchange.ajax.user.actions.SearchRequest request = new com.openexchange.ajax.user.actions.SearchRequest(searchObject, columns, true, parameters);
            com.openexchange.ajax.user.actions.SearchResponse response = Executor.execute(this.client, request);
            Contact[] result = this.jsonArray2ContactArray((JSONArray)response.getData(), columns);
            boolean stillGlobal = true;
            int previousCount = Integer.MAX_VALUE;
            for (Contact contactObject : result) {
                if (!stillGlobal) {
                    SearchTest.assertFalse((String)"Did not expect global contacts any more.", (contactObject.getParentFolderID() == 6 ? 1 : 0) != 0);
                }
                if (contactObject.getParentFolderID() != 6) {
                    stillGlobal = false;
                }
                if (stillGlobal) continue;
                SearchTest.assertTrue((String)"Wrong order of collected contacts.", (previousCount >= contactObject.getUseCount() ? 1 : 0) != 0);
                previousCount = contactObject.getUseCount();
            }
        }
        finally {
            this.deleteContacts(true, contactIds);
        }
    }

    private int[] insertSearchableContacts(int folderId) throws IOException, SAXException, JSONException, Exception {
        Contact contactObj = new Contact();
        contactObj.setSurName("Mustermann");
        contactObj.setGivenName("Tom");
        contactObj.setEmail1("tom.mustermann@email.com");
        contactObj.setParentFolderID(folderId);
        contactObj.setUseCount(1);
        Contact contactObj2 = new Contact();
        contactObj2.setSurName("Mustermann");
        contactObj2.setGivenName("Ute");
        contactObj2.setEmail1("ute.mustermann@email.com");
        contactObj2.setParentFolderID(folderId);
        contactObj2.setUseCount(2);
        Contact contactObj3 = new Contact();
        contactObj3.setSurName("Gloreich");
        contactObj3.setGivenName("Guenter");
        contactObj3.setParentFolderID(folderId);
        contactObj3.setUseCount(3);
        int objectId1 = this.insertContact(contactObj);
        int objectId2 = this.insertContact(contactObj2);
        int objectId3 = this.insertContact(contactObj3);
        return new int[]{objectId1, objectId2, objectId3};
    }

    private int[] insertSearchableContacts() throws IOException, SAXException, JSONException, Exception {
        return this.insertSearchableContacts(this.contactFolderId);
    }

    private void deleteContacts(boolean ignoreFailure, int ... ids) throws IOException, SAXException, JSONException, Exception {
        for (int objectId : ids) {
            this.deleteContact(objectId, this.contactFolderId, ignoreFailure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSearchByFirstAndLastName() throws Exception {
        int[] objectIds = this.insertSearchableContacts();
        try {
            ContactSearchObject cso = new ContactSearchObject();
            cso.setSurname("Must*");
            cso.setGivenName("U*");
            SearchRequest search = new SearchRequest(cso, new int[]{1, 502, 501}, true);
            SearchResponse result = this.client.execute(search);
            Object[][] rows = result.getArray();
            SearchTest.assertTrue((String)"contact array size > 0. Expected at least 1 result.", (rows.length > 0 ? 1 : 0) != 0);
            for (Object[] row : rows) {
                SearchTest.assertTrue((boolean)((String)row[1]).startsWith("Must"));
                SearchTest.assertTrue((((String)row[2]).length() > 0 && ((String)row[2]).charAt(0) == 'U' ? 1 : 0) != 0);
            }
        }
        finally {
            this.deleteContacts(true, objectIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOrSearchHabit() throws Exception {
        int[] objectIds = this.insertSearchableContacts();
        try {
            ContactSearchObject cso = new ContactSearchObject();
            cso.setSurname("Must*");
            cso.setGivenName("Gue*");
            cso.setOrSearch(true);
            SearchRequest search = new SearchRequest(cso, new int[]{1, 502, 501}, true);
            SearchResponse result = this.client.execute(search);
            Object[][] rows = result.getArray();
            SearchTest.assertTrue((String)"contact array size > 0. Expected at least 1 result.", (rows.length > 0 ? 1 : 0) != 0);
            boolean foundTom = false;
            boolean foundUte = false;
            boolean foundGuenter = false;
            for (Object[] row : rows) {
                if (row[2].equals("Ute")) {
                    foundUte = true;
                }
                if (row[2].equals("Tom")) {
                    foundTom = true;
                }
                if (!row[2].equals("Guenter")) continue;
                foundGuenter = true;
            }
            SearchTest.assertTrue((String)"Expected Ute Mustermann, but didn't find her", (boolean)foundUte);
            SearchTest.assertTrue((String)"Expected Tom Mustermann, but didn't find him", (boolean)foundTom);
            SearchTest.assertTrue((String)"Expected Guenter Glorreich, but didn't find her", (boolean)foundGuenter);
        }
        finally {
            this.deleteContacts(true, objectIds);
        }
    }
}

