/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact;

import com.openexchange.ajax.contact.AbstractContactTest;
import com.openexchange.ajax.contact.action.GetRequest;
import com.openexchange.ajax.contact.action.GetResponse;
import com.openexchange.configuration.MailConfig;
import com.openexchange.groupware.container.Contact;
import java.io.File;
import java.io.FileInputStream;

public class ContactImageScaleTest
extends AbstractContactTest {
    public ContactImageScaleTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateContact() throws Exception {
        try (FileInputStream input = null;){
            byte[] b;
            Contact contactObj = this.createContactObject("testContactWithImage");
            String testDataDir = MailConfig.getProperty(MailConfig.Property.TEST_MAIL_DIR);
            File file = new File(testDataDir, "oxlogo.png");
            input = new FileInputStream(file);
            byte[] bigImage = new byte[input.available()];
            input.read(bigImage);
            contactObj.setImage1(bigImage);
            contactObj.setImageContentType("image/png");
            int objectId = this.insertContact(contactObj);
            GetRequest request = new GetRequest(this.contactFolderId, objectId, this.tz);
            GetResponse response = this.client.execute(request);
            String imageUrl = response.getImageUrl();
            if (imageUrl == null) {
                ContactImageScaleTest.fail((String)"Contact contains no image URL.");
            }
            ContactImageScaleTest.assertTrue((String)"Wrong or no scaling", ((b = this.loadImageByURL(this.client.getProtocol(), this.client.getHostname(), imageUrl)).length < bigImage.length ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateContact() throws Exception {
        try (FileInputStream input = null;){
            byte[] b;
            Contact contactObj = this.createContactObject("testUpdateContactWithImageUpdate");
            int objectId = this.insertContact(contactObj);
            String testDataDir = MailConfig.getProperty(MailConfig.Property.TEST_MAIL_DIR);
            File file = new File(testDataDir, "oxlogo.png");
            input = new FileInputStream(file);
            byte[] bigImage = new byte[input.available()];
            input.read(bigImage);
            contactObj.setImage1(bigImage);
            contactObj.setImageContentType("image/png");
            contactObj.removeParentFolderID();
            this.updateContact(contactObj, this.contactFolderId);
            GetRequest request = new GetRequest(this.contactFolderId, objectId, this.tz);
            GetResponse response = this.client.execute(request);
            String imageUrl = response.getImageUrl();
            if (imageUrl == null) {
                ContactImageScaleTest.fail((String)"Contact contains no image URL.");
            }
            ContactImageScaleTest.assertTrue((String)"Wrong or no scaling", ((b = this.loadImageByURL(this.client.getProtocol(), this.client.getHostname(), imageUrl)).length < bigImage.length ? 1 : 0) != 0);
        }
    }
}

