/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact;

import com.openexchange.ajax.contact.action.AllRequest;
import com.openexchange.ajax.contact.action.InsertRequest;
import com.openexchange.ajax.folder.Create;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonAllResponse;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import java.util.Date;
import org.json.JSONArray;

public class Bug13931Test
extends AbstractAJAXSession {
    private int userId;
    private int privateFolderId;
    private int folderId;
    private FolderObject folder;
    private Contact AAA;
    private Contact aaa;
    private Contact BBB;
    private Contact bbb;
    private final int[] columns = new int[]{1, 502};

    public Bug13931Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.userId = this.getClient().getValues().getUserId();
        this.privateFolderId = this.getClient().getValues().getPrivateContactFolder();
        OCLPermission ocl = Create.ocl(this.userId, false, true, 128, 128, 128, 128);
        this.folder = Create.folder(this.privateFolderId, "Folder to test bug 13931 (" + new Date().getTime() + ")", 3, 1, ocl);
        CommonInsertResponse response = this.getClient().execute(new com.openexchange.ajax.folder.actions.InsertRequest((API)EnumAPI.OX_OLD, this.folder));
        response.fillObject((DataObject)this.folder);
        this.folderId = this.folder.getObjectID();
        this.AAA = new Contact();
        this.AAA.setParentFolderID(this.folderId);
        this.AAA.setSurName("AAA");
        this.client.execute(new InsertRequest(this.AAA)).fillObject((DataObject)this.AAA);
        this.BBB = new Contact();
        this.BBB.setParentFolderID(this.folderId);
        this.BBB.setSurName("BBB");
        this.client.execute(new InsertRequest(this.BBB)).fillObject((DataObject)this.BBB);
        this.aaa = new Contact();
        this.aaa.setParentFolderID(this.folderId);
        this.aaa.setSurName("aaa");
        this.client.execute(new InsertRequest(this.aaa)).fillObject((DataObject)this.aaa);
        this.bbb = new Contact();
        this.bbb.setParentFolderID(this.folderId);
        this.bbb.setSurName("bbb");
        this.client.execute(new InsertRequest(this.bbb)).fillObject((DataObject)this.bbb);
    }

    public void testBug13931() throws Exception {
        AllRequest allRequest = new AllRequest(this.folderId, this.columns);
        CommonAllResponse allResponse = this.client.execute(allRequest);
        JSONArray jsonArray = (JSONArray)allResponse.getResponse().getData();
        Bug13931Test.assertNotNull((String)"No result", (Object)jsonArray);
        Bug13931Test.assertEquals((String)"Wrong amount of results", (int)4, (int)jsonArray.length());
        Bug13931Test.assertEquals((String)"Wrong order", (int)this.AAA.getObjectID(), (int)jsonArray.getJSONArray(0).getInt(0));
        Bug13931Test.assertEquals((String)"Wrong order", (int)this.aaa.getObjectID(), (int)jsonArray.getJSONArray(1).getInt(0));
        Bug13931Test.assertEquals((String)"Wrong order", (int)this.BBB.getObjectID(), (int)jsonArray.getJSONArray(2).getInt(0));
        Bug13931Test.assertEquals((String)"Wrong order", (int)this.bbb.getObjectID(), (int)jsonArray.getJSONArray(3).getInt(0));
    }

    @Override
    public void tearDown() throws Exception {
        this.getClient().execute(new DeleteRequest((API)EnumAPI.OX_OLD, this.folder.getObjectID(), this.folder.getLastModified()));
        super.tearDown();
    }
}

