/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact;

import com.openexchange.ajax.contact.AbstractManagedContactTest;
import com.openexchange.ajax.contact.action.SearchByBirthdayRequest;
import com.openexchange.ajax.framework.CommonSearchResponse;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Contact;
import java.util.List;
import org.json.JSONArray;

public class BirthdayAndAnniversaryTest
extends AbstractManagedContactTest {
    public BirthdayAndAnniversaryTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void testSearchByBirthday() throws Exception {
        Contact contact1 = super.generateContact("M\u00e4rz");
        contact1.setBirthday(TimeTools.D("1988-03-03 00:00"));
        contact1 = this.manager.newAction(contact1);
        Contact contact2 = super.generateContact("Juli");
        contact2.setBirthday(TimeTools.D("1977-07-07 00:00:00"));
        contact2 = this.manager.newAction(contact2);
        Contact contact3 = super.generateContact("Oktober");
        contact3.setBirthday(TimeTools.D("1910-10-10 00:00:00"));
        contact3 = this.manager.newAction(contact3);
        String parentFolderID = String.valueOf(contact1.getParentFolderID());
        int[] columns = new int[]{1, 511, 20};
        SearchByBirthdayRequest request = new SearchByBirthdayRequest(TimeTools.D("2013-01-01 00:00:00"), TimeTools.D("2013-09-01 00:00:00"), parentFolderID, columns, true);
        CommonSearchResponse response = this.client.execute(request);
        List<Contact> contacts = this.manager.transform((JSONArray)response.getResponse().getData(), columns);
        BirthdayAndAnniversaryTest.assertNotNull(contacts);
        BirthdayAndAnniversaryTest.assertEquals((String)"wrong number of results", (int)2, (int)contacts.size());
        request = new SearchByBirthdayRequest(TimeTools.D("2013-01-01 00:00:00"), TimeTools.D("2014-01-01 00:00:00"), parentFolderID, columns, true);
        response = this.client.execute(request);
        contacts = this.manager.transform((JSONArray)response.getResponse().getData(), columns);
        BirthdayAndAnniversaryTest.assertNotNull(contacts);
        BirthdayAndAnniversaryTest.assertEquals((String)"wrong number of results", (int)3, (int)contacts.size());
        request = new SearchByBirthdayRequest(TimeTools.D("2013-06-01 00:00:00"), TimeTools.D("2014-01-01 00:00:00"), parentFolderID, columns, true);
        response = this.client.execute(request);
        contacts = this.manager.transform((JSONArray)response.getResponse().getData(), columns);
        BirthdayAndAnniversaryTest.assertNotNull(contacts);
        BirthdayAndAnniversaryTest.assertEquals((String)"wrong number of results", (int)2, (int)contacts.size());
        request = new SearchByBirthdayRequest(TimeTools.D("2013-03-04 00:00:00"), TimeTools.D("2013-07-06 00:00:00"), parentFolderID, columns, true);
        response = this.client.execute(request);
        contacts = this.manager.transform((JSONArray)response.getResponse().getData(), columns);
        BirthdayAndAnniversaryTest.assertNotNull(contacts);
        BirthdayAndAnniversaryTest.assertEquals((String)"wrong number of results", (int)0, (int)contacts.size());
        request = new SearchByBirthdayRequest(TimeTools.D("2085-03-03 00:00:00"), TimeTools.D("2085-03-03 01:01:00"), parentFolderID, columns, true);
        response = this.client.execute(request);
        contacts = this.manager.transform((JSONArray)response.getResponse().getData(), columns);
        BirthdayAndAnniversaryTest.assertNotNull(contacts);
        BirthdayAndAnniversaryTest.assertEquals((String)"wrong number of results", (int)1, (int)contacts.size());
    }
}

