/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.config;

import com.openexchange.ajax.config.actions.GetRequest;
import com.openexchange.ajax.config.actions.GetResponse;
import com.openexchange.ajax.config.actions.SetRequest;
import com.openexchange.ajax.config.actions.Tree;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.java.Autoboxing;
import com.openexchange.tools.arrays.Arrays;
import java.util.Random;
import java.util.TimeZone;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigMenuTest
extends AbstractAJAXSession {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigMenuTest.class);
    private static final Random RAND = new Random(System.currentTimeMillis());

    public ConfigMenuTest(String name) {
        super(name);
    }

    public void testReadSettings() throws Throwable {
        GetRequest request = new GetRequest(Tree.ALL);
        GetResponse response = this.getClient().execute(request);
        JSONObject settings = response.getJSON();
        LOG.trace("Settings: {}", (Object)settings.toString());
        ConfigMenuTest.assertTrue((String)"Got no value from server.", (settings.length() > 0 ? 1 : 0) != 0);
    }

    public void testHasSpam() throws Throwable {
        GetRequest request = new GetRequest(Tree.SpamButton);
        GetResponse response = this.getClient().execute(request);
        boolean spamButtonEnabled = response.getBoolean();
        LOG.trace("Spam Button enabled: {}", (Object)Autoboxing.B((boolean)spamButtonEnabled));
        ConfigMenuTest.assertTrue((String)"Got no spam-button-enabled flag from server.", (boolean)response.hasValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimeZone() throws Throwable {
        GetRequest getRequest = new GetRequest(Tree.TimeZone);
        GetResponse getResponse = this.getClient().execute(getRequest);
        String origTimeZone = getResponse.getString();
        String[] zones = (String[])Arrays.remove((Object[])TimeZone.getAvailableIDs(), (Object[])new String[]{origTimeZone});
        String testTimeZone = zones[RAND.nextInt(zones.length)];
        SetRequest setRequest = new SetRequest(Tree.TimeZone, testTimeZone);
        try {
            this.getClient().execute(setRequest);
            getResponse = this.getClient().execute(getRequest);
            ConfigMenuTest.assertEquals((String)("Written timezone isn't returned from server. Used session id: " + this.getClient().getSession().getId()), (String)testTimeZone, (String)getResponse.getString());
        }
        finally {
            setRequest = new SetRequest(Tree.TimeZone, origTimeZone);
            this.getClient().execute(setRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBeta() throws Throwable {
        GetRequest getRequest = new GetRequest(Tree.Beta);
        GetResponse getResponse = this.getClient().execute(getRequest);
        boolean beta = getResponse.getBoolean();
        boolean testBeta = false;
        SetRequest setRequest = new SetRequest(Tree.Beta, Autoboxing.B((boolean)false));
        try {
            this.getClient().execute(setRequest);
            getResponse = this.getClient().execute(getRequest);
            ConfigMenuTest.assertEquals((String)"Written beta attribute isn't returned from server.", (boolean)false, (boolean)getResponse.getBoolean());
        }
        finally {
            setRequest = new SetRequest(Tree.Beta, Autoboxing.B((boolean)beta));
            this.getClient().execute(setRequest);
        }
    }

    public void testIdentifier() throws Throwable {
        GetRequest request = new GetRequest(Tree.Identifier);
        GetResponse response = this.getClient().execute(request);
        int userId = response.getInteger();
        LOG.trace("UserId: {}", (Object)Autoboxing.I((int)userId));
        ConfigMenuTest.assertTrue((String)"No valid user identifier", (userId > 0 ? 1 : 0) != 0);
    }
}

