/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.config.actions.GetRequest;
import com.openexchange.ajax.config.actions.GetResponse;
import com.openexchange.ajax.config.actions.SetRequest;
import com.openexchange.ajax.config.actions.Tree;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.test.CalendarTestManager;
import java.util.TimeZone;

public class WeirdRecurrencePatternTest
extends AbstractAJAXSession {
    private String origTimeZone;
    private CalendarTestManager ctm;
    private Appointment appointment;
    private TimeZone tz;

    public WeirdRecurrencePatternTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        GetRequest getRequest = new GetRequest(Tree.TimeZone);
        GetResponse getResponse = this.getClient().execute(getRequest);
        this.origTimeZone = getResponse.getString();
        this.tz = TimeZone.getTimeZone("Europe/Berlin");
        SetRequest setRequest = new SetRequest(Tree.TimeZone, this.tz.getID());
        this.getClient().execute(setRequest);
        this.ctm = new CalendarTestManager(this.client);
        this.appointment = new Appointment();
        this.appointment.setTitle("hiliowequhe234123.3");
        this.appointment.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        this.appointment.setRecurrenceType(1);
        this.appointment.setInterval(1);
        this.appointment.setIgnoreConflicts(true);
    }

    public void testPattern() throws Exception {
        this.appointment.setStartDate(TimeTools.D("06.01.2015 15:30", this.tz));
        this.appointment.setEndDate(TimeTools.D("06.01.2015 16:30", this.tz));
        this.appointment.setTimezone(this.tz.getID());
        this.ctm.insert(this.appointment);
        Appointment loaded = this.ctm.get(this.appointment.getParentFolderID(), this.appointment.getObjectID());
        WeirdRecurrencePatternTest.assertEquals((String)"Wrong start date.", (Object)TimeTools.D("06.01.2015 15:30", this.tz), (Object)loaded.getStartDate());
        WeirdRecurrencePatternTest.assertEquals((String)"Wrong end date.", (Object)TimeTools.D("06.01.2015 16:30", this.tz), (Object)loaded.getEndDate());
    }

    @Override
    public void tearDown() throws Exception {
        this.ctm.cleanUp();
        SetRequest setRequest = new SetRequest(Tree.TimeZone, this.origTimeZone);
        this.getClient().execute(setRequest);
        super.tearDown();
    }
}

