/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.test.CalendarTestManager;
import java.util.Date;
import java.util.TimeZone;

public class Bug37668Test
extends AbstractAJAXSession {
    private CalendarTestManager ctm;
    private Appointment appSimple;
    private TimeZone timeZone;
    private TimeZone utc = TimeZone.getTimeZone("UTC");
    private Appointment app23h;
    private Appointment app25h;
    private Appointment fulltime;
    private Appointment fulltime2days;

    public Bug37668Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.ctm = new CalendarTestManager(this.client);
        this.timeZone = this.getClient().getValues().getTimeZone();
        this.appSimple = new Appointment();
        this.appSimple.setStartDate(TimeTools.D("14.01.2015 16:00", this.timeZone));
        this.appSimple.setEndDate(TimeTools.D("14.01.2015 17:00", this.timeZone));
        this.appSimple.setRecurrenceType(4);
        this.appSimple.setInterval(1);
        this.appSimple.setDayInMonth(22);
        this.appSimple.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        this.appSimple.setIgnoreConflicts(true);
        this.appSimple.setTimezone(this.timeZone.getID());
        this.app23h = new Appointment();
        this.app23h.setStartDate(TimeTools.D("14.01.2015 16:00", this.timeZone));
        this.app23h.setEndDate(TimeTools.D("15.01.2015 15:00", this.timeZone));
        this.app23h.setRecurrenceType(4);
        this.app23h.setInterval(1);
        this.app23h.setDayInMonth(22);
        this.app23h.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        this.app23h.setIgnoreConflicts(true);
        this.app23h.setTimezone(this.timeZone.getID());
        this.app25h = new Appointment();
        this.app25h.setStartDate(TimeTools.D("14.01.2015 16:00", this.timeZone));
        this.app25h.setEndDate(TimeTools.D("15.01.2015 17:00", this.timeZone));
        this.app25h.setRecurrenceType(4);
        this.app25h.setInterval(1);
        this.app25h.setDayInMonth(22);
        this.app25h.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        this.app25h.setIgnoreConflicts(true);
        this.app25h.setTimezone(this.timeZone.getID());
        this.fulltime = new Appointment();
        this.fulltime.setStartDate(TimeTools.D("14.01.2015 16:00", this.timeZone));
        this.fulltime.setEndDate(TimeTools.D("14.01.2015 17:00", this.timeZone));
        this.fulltime.setRecurrenceType(4);
        this.fulltime.setInterval(1);
        this.fulltime.setDayInMonth(22);
        this.fulltime.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        this.fulltime.setIgnoreConflicts(true);
        this.fulltime.setTimezone(this.timeZone.getID());
        this.fulltime.setFullTime(true);
        this.fulltime2days = new Appointment();
        this.fulltime2days.setStartDate(TimeTools.D("14.01.2015 10:00", this.timeZone));
        this.fulltime2days.setEndDate(TimeTools.D("16.01.2015 10:00", this.timeZone));
        this.fulltime2days.setRecurrenceType(4);
        this.fulltime2days.setInterval(1);
        this.fulltime2days.setDayInMonth(22);
        this.fulltime2days.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        this.fulltime2days.setIgnoreConflicts(true);
        this.fulltime2days.setTimezone(this.timeZone.getID());
        this.fulltime2days.setFullTime(true);
    }

    public void testBug37668_JAN() throws Exception {
        this.doTest(0);
    }

    public void testBug37668_FEB() throws Exception {
        this.doTest(1);
    }

    public void testBug37668_MAR() throws Exception {
        this.doTest(2);
    }

    public void testBug37668_APR() throws Exception {
        this.doTest(3);
    }

    public void testBug37668_MAY() throws Exception {
        this.doTest(4);
    }

    public void testBug37668_JUN() throws Exception {
        this.doTest(5);
    }

    public void testBug37668_JUL() throws Exception {
        this.doTest(6);
    }

    public void testBug37668_AUG() throws Exception {
        this.doTest(7);
    }

    public void testBug37668_SEP() throws Exception {
        this.doTest(8);
    }

    public void testBug37668_OCT() throws Exception {
        this.doTest(9);
    }

    public void testBug37668_NOV() throws Exception {
        this.doTest(10);
    }

    public void testBug37668_DEC() throws Exception {
        this.doTest(11);
    }

    private void doTest(int month) throws Exception {
        this.appSimple.setMonth(month);
        this.appSimple.setTitle("Bug 37668 Test (" + (month + 1) + ") simple.");
        this.app23h.setMonth(month);
        this.app23h.setTitle("Bug 37668 Test (" + (month + 1) + ") 23h.");
        this.app25h.setMonth(month);
        this.app25h.setTitle("Bug 37668 Test (" + (month + 1) + ") 25h.");
        this.fulltime.setMonth(month);
        this.fulltime.setTitle("Bug 37668 Test (" + (month + 1) + ") fulltime.");
        this.fulltime2days.setMonth(month);
        this.fulltime2days.setTitle("Bug 37668 Test (" + (month + 1) + ") fulltime 2 days.");
        this.ctm.insert(this.appSimple);
        this.ctm.insert(this.app23h);
        this.ctm.insert(this.app25h);
        this.ctm.insert(this.fulltime);
        this.ctm.insert(this.fulltime2days);
        Appointment delete = new Appointment();
        delete.setObjectID(this.appSimple.getObjectID());
        delete.setParentFolderID(this.appSimple.getParentFolderID());
        delete.setRecurrencePosition(1);
        delete.setLastModified(new Date(Long.MAX_VALUE));
        this.ctm.delete(delete);
        delete.setObjectID(this.app25h.getObjectID());
        delete.setParentFolderID(this.app25h.getParentFolderID());
        this.ctm.delete(delete);
        delete.setObjectID(this.app23h.getObjectID());
        delete.setParentFolderID(this.app23h.getParentFolderID());
        this.ctm.delete(delete);
        delete.setObjectID(this.fulltime.getObjectID());
        delete.setParentFolderID(this.fulltime.getParentFolderID());
        this.ctm.delete(delete);
        delete.setObjectID(this.fulltime2days.getObjectID());
        delete.setParentFolderID(this.fulltime2days.getParentFolderID());
        this.ctm.delete(delete);
        Appointment loadSimple = this.ctm.get(this.appSimple.getParentFolderID(), this.appSimple.getObjectID());
        Bug37668Test.assertEquals((String)("Wrong start date. (" + loadSimple.getTitle() + ")"), (Object)TimeTools.D("22." + (month + 1) + ".2015 16:00", this.timeZone), (Object)loadSimple.getStartDate());
        Bug37668Test.assertEquals((String)("Wrong end date. (" + loadSimple.getTitle() + ")"), (Object)TimeTools.D("22." + (month + 1) + ".2015 17:00", this.timeZone), (Object)loadSimple.getEndDate());
        Bug37668Test.assertNotNull((String)"Expected a delete Exception.", (Object)loadSimple.getDeleteException());
        Bug37668Test.assertEquals((String)"Expected a delete Exception.", (int)1, (int)loadSimple.getDeleteException().length);
        Appointment load23h = this.ctm.get(this.app23h.getParentFolderID(), this.app23h.getObjectID());
        Bug37668Test.assertEquals((String)("Wrong start date. (" + load23h.getTitle() + ")"), (Object)TimeTools.D("22." + (month + 1) + ".2015 16:00", this.timeZone), (Object)load23h.getStartDate());
        Bug37668Test.assertEquals((String)("Wrong end date. (" + load23h.getTitle() + ")"), (Object)TimeTools.D("23." + (month + 1) + ".2015 15:00", this.timeZone), (Object)load23h.getEndDate());
        Bug37668Test.assertNotNull((String)"Expected a delete Exception.", (Object)load23h.getDeleteException());
        Bug37668Test.assertEquals((String)"Expected a delete Exception.", (int)1, (int)load23h.getDeleteException().length);
        Appointment load25h = this.ctm.get(this.app25h.getParentFolderID(), this.app25h.getObjectID());
        Bug37668Test.assertEquals((String)("Wrong start date. (" + load25h.getTitle() + ")"), (Object)TimeTools.D("22." + (month + 1) + ".2015 16:00", this.timeZone), (Object)load25h.getStartDate());
        Bug37668Test.assertEquals((String)("Wrong end date. (" + load25h.getTitle() + ")"), (Object)TimeTools.D("23." + (month + 1) + ".2015 17:00", this.timeZone), (Object)load25h.getEndDate());
        Bug37668Test.assertNotNull((String)"Expected a delete Exception.", (Object)load25h.getDeleteException());
        Bug37668Test.assertEquals((String)"Expected a delete Exception.", (int)1, (int)load25h.getDeleteException().length);
        Appointment loadFulltime = this.ctm.get(this.fulltime.getParentFolderID(), this.fulltime.getObjectID());
        Bug37668Test.assertEquals((String)("Wrong start date. (" + loadFulltime.getTitle() + ")"), (Object)TimeTools.D("22." + (month + 1) + ".2015 00:00", this.utc), (Object)loadFulltime.getStartDate());
        Bug37668Test.assertEquals((String)("Wrong end date. (" + loadFulltime.getTitle() + ")"), (Object)TimeTools.D("23." + (month + 1) + ".2015 00:00", this.utc), (Object)loadFulltime.getEndDate());
        Bug37668Test.assertNotNull((String)"Expected a delete Exception.", (Object)loadFulltime.getDeleteException());
        Bug37668Test.assertEquals((String)"Expected a delete Exception.", (int)1, (int)loadFulltime.getDeleteException().length);
        Appointment loadFulltime2days = this.ctm.get(this.fulltime2days.getParentFolderID(), this.fulltime2days.getObjectID());
        Bug37668Test.assertEquals((String)("Wrong start date. (" + loadFulltime2days.getTitle() + ")"), (Object)TimeTools.D("22." + (month + 1) + ".2015 00:00", this.utc), (Object)loadFulltime2days.getStartDate());
        Bug37668Test.assertEquals((String)("Wrong end date. (" + loadFulltime2days.getTitle() + ")"), (Object)TimeTools.D("24." + (month + 1) + ".2015 00:00", this.utc), (Object)loadFulltime2days.getEndDate());
        Bug37668Test.assertNotNull((String)"Expected a delete Exception.", (Object)loadFulltime2days.getDeleteException());
        Bug37668Test.assertEquals((String)"Expected a delete Exception.", (int)1, (int)loadFulltime2days.getDeleteException().length);
    }

    @Override
    public void tearDown() throws Exception {
        this.ctm.cleanUp();
        super.tearDown();
    }
}

