/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.test.CalendarTestManager;
import java.util.Date;
import java.util.TimeZone;

public class Bug37198Test
extends AbstractAJAXSession {
    private CalendarTestManager ctm;
    private Appointment app;
    private TimeZone utc;

    public Bug37198Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.ctm = new CalendarTestManager(this.client);
        this.app = new Appointment();
        this.app.setTitle("Bug 37198 Test");
        this.utc = TimeZone.getTimeZone("UTC");
        this.app.setStartDate(TimeTools.D("12.03.2015 00:00", this.utc));
        this.app.setEndDate(TimeTools.D("13.03.2015 00:00", this.utc));
        this.app.setFullTime(true);
        this.app.setRecurrenceType(1);
        this.app.setUntil(TimeTools.D("13.03.2015 00:00", this.utc));
        this.app.setInterval(1);
        this.app.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        this.app.setIgnoreConflicts(true);
    }

    public void testBug37198() throws Exception {
        this.ctm.setFailOnError(true);
        this.ctm.insert(this.app);
        Appointment update = new Appointment();
        update.setObjectID(this.app.getObjectID());
        update.setParentFolderID(this.app.getParentFolderID());
        update.setEndDate(TimeTools.D("14.03.2015 00:00", this.utc));
        update.setRecurrenceType(0);
        update.setLastModified(new Date(Long.MAX_VALUE));
        update.setIgnoreConflicts(true);
        this.ctm.update(update);
    }

    @Override
    public void tearDown() throws Exception {
        this.ctm.cleanUp();
        super.tearDown();
    }
}

