/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.ConflictObject;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.java.util.TimeZones;
import com.openexchange.test.CalendarTestManager;
import java.util.Calendar;
import java.util.List;

public class Bug31963Test
extends AbstractAJAXSession {
    private CalendarTestManager ctm;

    public Bug31963Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.ctm = new CalendarTestManager(this.getClient());
    }

    @Override
    protected void tearDown() throws Exception {
        this.ctm.cleanUp();
        super.tearDown();
    }

    public void testNotConflictingAppointment() throws Exception {
        int folderID = super.getClient().getValues().getPrivateAppointmentFolder();
        int nextYear = Calendar.getInstance().get(1) + 1;
        Appointment appointment = new Appointment();
        appointment.setParentFolderID(folderID);
        appointment.setTitle(((Object)((Object)this)).getClass().getName());
        appointment.setStartDate(TimeTools.D("28.04." + nextYear + " 00:00", TimeZones.UTC));
        appointment.setEndDate(TimeTools.D("29.04." + nextYear + " 00:00", TimeZones.UTC));
        appointment.setFullTime(true);
        appointment.setIgnoreConflicts(true);
        appointment = this.ctm.insert(appointment);
        Appointment notConflictingAppointment = new Appointment();
        notConflictingAppointment.setParentFolderID(folderID);
        notConflictingAppointment.setTitle(((Object)((Object)this)).getClass().getName());
        notConflictingAppointment.setStartDate(TimeTools.D("27.04." + nextYear + " 23:00", this.getClient().getValues().getTimeZone()));
        notConflictingAppointment.setEndDate(TimeTools.D("28.04." + nextYear + " 00:00", this.getClient().getValues().getTimeZone()));
        notConflictingAppointment.setIgnoreConflicts(false);
        this.ctm.insert(notConflictingAppointment);
        List<ConflictObject> conflicts = this.ctm.getLastResponse().getConflicts();
        Bug31963Test.assertTrue((String)"conflicts detected", (null == conflicts || 0 == conflicts.size() ? 1 : 0) != 0);
        notConflictingAppointment = new Appointment();
        notConflictingAppointment.setParentFolderID(folderID);
        notConflictingAppointment.setTitle(((Object)((Object)this)).getClass().getName());
        notConflictingAppointment.setStartDate(TimeTools.D("29.04." + nextYear + " 00:00", this.getClient().getValues().getTimeZone()));
        notConflictingAppointment.setEndDate(TimeTools.D("29.04." + nextYear + " 01:00", this.getClient().getValues().getTimeZone()));
        notConflictingAppointment.setIgnoreConflicts(false);
        this.ctm.insert(notConflictingAppointment);
        conflicts = this.ctm.getLastResponse().getConflicts();
        Bug31963Test.assertTrue((String)"conflicts detected", (null == conflicts || 0 == conflicts.size() ? 1 : 0) != 0);
        Appointment conflictingAppointment = new Appointment();
        conflictingAppointment.setParentFolderID(folderID);
        conflictingAppointment.setTitle(((Object)((Object)this)).getClass().getName());
        conflictingAppointment.setStartDate(TimeTools.D("28.04." + nextYear + " 00:00", this.getClient().getValues().getTimeZone()));
        conflictingAppointment.setEndDate(TimeTools.D("28.04." + nextYear + " 01:00", this.getClient().getValues().getTimeZone()));
        conflictingAppointment.setIgnoreConflicts(false);
        this.ctm.insert(conflictingAppointment);
        conflicts = this.ctm.getLastResponse().getConflicts();
        Bug31963Test.assertTrue((String)"no conflicts detected", (null != conflicts && 0 < conflicts.size() ? 1 : 0) != 0);
        conflictingAppointment = new Appointment();
        conflictingAppointment.setParentFolderID(folderID);
        conflictingAppointment.setTitle(((Object)((Object)this)).getClass().getName());
        conflictingAppointment.setStartDate(TimeTools.D("28.04." + nextYear + " 23:00", this.getClient().getValues().getTimeZone()));
        conflictingAppointment.setEndDate(TimeTools.D("29.04." + nextYear + " 00:00", this.getClient().getValues().getTimeZone()));
        conflictingAppointment.setIgnoreConflicts(false);
        this.ctm.insert(conflictingAppointment);
        conflicts = this.ctm.getLastResponse().getConflicts();
        Bug31963Test.assertTrue((String)"no conflicts detected", (null != conflicts && 0 < conflicts.size() ? 1 : 0) != 0);
    }
}

