/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.test.CalendarTestManager;
import com.openexchange.test.FolderTestManager;

public class Bug30142Test
extends AbstractAJAXSession {
    private CalendarTestManager ctm;
    private FolderTestManager ftm;
    private FolderObject folder;
    private Appointment appointment;

    public Bug30142Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.ctm = new CalendarTestManager(this.client);
        this.ftm = new FolderTestManager(this.client);
        this.folder = this.ftm.generatePrivateFolder("Bug 30142 " + System.currentTimeMillis(), 2, this.client.getValues().getPrivateAppointmentFolder(), this.client.getValues().getUserId());
        this.ftm.insertFolderOnServer(this.folder);
        this.appointment = new Appointment();
        this.appointment.setTitle("Bug 30142");
        this.appointment.setStartDate(TimeTools.D("01.12.2013 08:00"));
        this.appointment.setEndDate(TimeTools.D("01.12.2013 09:00"));
        this.appointment.setParentFolderID(this.folder.getObjectID());
        this.appointment.setIgnoreConflicts(true);
        this.ctm.insert(this.appointment);
    }

    public void testBug30142() throws Exception {
        Appointment update = this.ctm.createIdentifyingCopy(this.appointment);
        update.setCategories("Test");
        this.ctm.update(update);
        Appointment loaded = this.ctm.get(this.folder.getObjectID(), this.appointment.getObjectID());
        Bug30142Test.assertEquals((String)"Missing category.", (String)"Test", (String)loaded.getCategories());
        Bug30142Test.assertEquals((String)"Bad folder id.", (int)loaded.getParentFolderID(), (int)this.folder.getObjectID());
    }

    @Override
    public void tearDown() throws Exception {
        this.ftm.cleanUp();
        this.ctm.cleanUp();
        super.tearDown();
    }
}

