/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.ConfirmRequest;
import com.openexchange.ajax.appointment.action.ConfirmResponse;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.UpdateRequest;
import com.openexchange.ajax.appointment.action.UpdateResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.participant.ParticipantTools;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.UserParticipant;
import java.io.IOException;
import java.util.Date;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class Bug13942Test
extends AbstractAJAXSession {
    private Appointment appointment;
    private Appointment updateAppointment;
    private int userIdA;
    private int userIdB;
    private int userIdC;
    private AJAXClient clientB;
    private AJAXClient clientC;

    public Bug13942Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.userIdA = this.getClient().getValues().getUserId();
        this.userIdB = this.getClientB().getValues().getUserId();
        this.userIdC = this.getClientC().getValues().getUserId();
        this.appointment = new Appointment();
        this.appointment.setParentFolderID(this.getClient().getValues().getPrivateAppointmentFolder());
        this.appointment.setTitle("Test Bug 13942");
        this.appointment.setStartDate(new Date(TimeTools.getHour(0, this.getClient().getValues().getTimeZone())));
        this.appointment.setEndDate(new Date(TimeTools.getHour(1, this.getClient().getValues().getTimeZone())));
        this.appointment.setParticipants(ParticipantTools.createParticipants(this.userIdA, this.userIdB, this.userIdC));
        this.appointment.setIgnoreConflicts(true);
        InsertRequest request = new InsertRequest(this.appointment, this.getClient().getValues().getTimeZone());
        AppointmentInsertResponse response = this.getClient().execute(request);
        response.fillObject((DataObject)this.appointment);
        ConfirmRequest confirmRequest = new ConfirmRequest(this.getClientB().getValues().getPrivateAppointmentFolder(), this.appointment.getObjectID(), 1, "yap", this.appointment.getLastModified(), true);
        ConfirmResponse confirmResponse = this.getClientB().execute(confirmRequest);
        this.appointment.setLastModified(confirmResponse.getTimestamp());
        this.updateAppointment = new Appointment();
        this.updateAppointment.setObjectID(this.appointment.getObjectID());
        this.updateAppointment.setParentFolderID(this.getClientB().getValues().getPrivateAppointmentFolder());
        this.updateAppointment.setLastModified(this.appointment.getLastModified());
        this.updateAppointment.setAlarm(30);
    }

    @Override
    public void tearDown() throws Exception {
        if (this.appointment != null && this.appointment.getObjectID() != 0) {
            DeleteRequest delete = new DeleteRequest(this.appointment);
            this.getClient().execute(delete);
        }
        super.tearDown();
    }

    public void testBug13942() throws Exception {
        UpdateRequest updateRequest = new UpdateRequest(this.updateAppointment, this.getClientB().getValues().getTimeZone());
        UpdateResponse updateResponse = this.getClientB().execute(updateRequest);
        this.appointment.setLastModified(updateResponse.getTimestamp());
        GetRequest getRequest = new GetRequest(this.getClientB().getValues().getPrivateAppointmentFolder(), this.appointment.getObjectID());
        GetResponse getResponse = this.getClientB().execute(getRequest);
        Appointment loadedAppointment = getResponse.getAppointment(this.getClientB().getValues().getTimeZone());
        for (UserParticipant user : loadedAppointment.getUsers()) {
            if (user.getIdentifier() != this.userIdB) continue;
            Bug13942Test.assertEquals((String)"Lost confirmation status", (int)1, (int)user.getConfirm());
        }
    }

    private AJAXClient getClientB() throws OXException, OXException, IOException, SAXException, JSONException {
        if (this.clientB == null) {
            this.clientB = new AJAXClient(AJAXClient.User.User2);
        }
        return this.clientB;
    }

    private AJAXClient getClientC() throws OXException, OXException, IOException, SAXException, JSONException {
        if (this.clientC == null) {
            this.clientC = new AJAXClient(AJAXClient.User.User3);
        }
        return this.clientC;
    }
}

