/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.ExternalUserParticipant;
import com.openexchange.groupware.container.Participant;
import java.util.Calendar;
import java.util.TimeZone;

public final class Bug12444Test
extends AbstractAJAXSession {
    public Bug12444Test(String name) {
        super(name);
    }

    public void testExternalWithoutEmail() throws Throwable {
        int folderId = this.client.getValues().getPrivateAppointmentFolder();
        TimeZone tz = this.client.getValues().getTimeZone();
        Appointment appointment = new Appointment();
        appointment.setTitle("Test for bug 12444");
        Calendar calendar = TimeTools.createCalendar(tz);
        appointment.setStartDate(calendar.getTime());
        calendar.add(11, 1);
        appointment.setEndDate(calendar.getTime());
        appointment.setParentFolderID(folderId);
        appointment.setParticipants(this.createParticipants());
        InsertRequest request = new InsertRequest(appointment, tz, false);
        CommonInsertResponse response = this.client.execute(request);
        Bug12444Test.assertTrue((String)"Server responded not with expected exception.", (boolean)response.hasError());
        OXException e = response.getException();
        Bug12444Test.assertEquals((String)"Wrong exception code.", (int)8, (int)e.getCode());
        Bug12444Test.assertEquals((String)"Wrong exception category.", (Object)Category.CATEGORY_USER_INPUT, (Object)e.getCategory());
    }

    private Participant[] createParticipants() {
        ExternalUserParticipant p1 = new ExternalUserParticipant("");
        p1.setDisplayName("User 1");
        ExternalUserParticipant p2 = new ExternalUserParticipant("user@example.com");
        p2.setDisplayName("User 2");
        return new Participant[]{p1, p2};
    }
}

