/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.UpdateRequest;
import com.openexchange.ajax.appointment.action.UpdateResponse;
import com.openexchange.ajax.folder.Create;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;

public class PrivateTests
extends AbstractAJAXSession {
    private AJAXClient client1;
    private AJAXClient client2;
    private AJAXClient client3;
    private AJAXClient client4;
    private FolderObject folder;
    private Appointment app;

    public PrivateTests(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client1 = this.getClient();
        this.client2 = new AJAXClient(AJAXClient.User.User2);
        this.client3 = new AJAXClient(AJAXClient.User.User3);
        this.client4 = new AJAXClient(AJAXClient.User.User4);
        this.folder = Create.folder(1, "Private Test Folder" + System.currentTimeMillis(), 2, 1, Create.ocl(this.client1.getValues().getUserId(), false, true, 128, 128, 128, 128), Create.ocl(this.client2.getValues().getUserId(), false, false, 128, 128, 128, 128), Create.ocl(this.client3.getValues().getUserId(), false, false, 128, 128, 128, 128));
        CommonInsertResponse response = this.client1.execute(new com.openexchange.ajax.folder.actions.InsertRequest((API)EnumAPI.OX_NEW, this.folder));
        response.fillObject((DataObject)this.folder);
    }

    public void testBasicPrivate() throws Exception {
        this.app = new Appointment();
        this.app.setIgnoreConflicts(true);
        this.app.setTitle("com.openexchange.ajax.appointment.PrivateTests.testBasicPrivate");
        this.app.setStartDate(TimeTools.D("01.07.2013 08:00"));
        this.app.setEndDate(TimeTools.D("01.07.2013 09:00"));
        this.app.setLocation("Hier und da");
        this.app.setPrivateFlag(true);
        this.app.setParentFolderID(this.client1.getValues().getPrivateAppointmentFolder());
        InsertRequest insertRequest = new InsertRequest(this.app, this.client1.getValues().getTimeZone());
        AppointmentInsertResponse insertResponse = this.client1.execute(insertRequest);
        insertResponse.fillObject((DataObject)this.app);
        GetRequest get = new GetRequest(this.folder.getObjectID(), this.app.getObjectID());
        GetResponse getResponse = this.client2.execute(get);
        Appointment loaded = getResponse.getAppointment(this.client2.getValues().getTimeZone());
        PrivateTests.assertNull((String)"Did not expect data.", (Object)loaded.getLocation());
        get = new GetRequest(this.folder.getObjectID(), this.app.getObjectID());
        getResponse = this.client3.execute(get);
        loaded = getResponse.getAppointment(this.client3.getValues().getTimeZone());
        PrivateTests.assertNull((String)"Did not expect data.", (Object)loaded.getLocation());
        get = new GetRequest(this.folder.getObjectID(), this.app.getObjectID(), false);
        getResponse = this.client4.execute(get);
        PrivateTests.assertTrue((String)"Expected error.", (boolean)getResponse.hasError());
    }

    public void testPrivateWithParticipant() throws Exception {
        this.app = new Appointment();
        this.app.setIgnoreConflicts(true);
        this.app.setTitle("com.openexchange.ajax.appointment.PrivateTests.testBasicPrivate");
        this.app.setStartDate(TimeTools.D("01.07.2013 08:00"));
        this.app.setEndDate(TimeTools.D("01.07.2013 09:00"));
        this.app.setLocation("Hier und da");
        this.app.setPrivateFlag(true);
        this.app.setParentFolderID(this.folder.getObjectID());
        this.app.setUsers(new UserParticipant[]{new UserParticipant(this.client1.getValues().getUserId()), new UserParticipant(this.client2.getValues().getUserId()), new UserParticipant(this.client4.getValues().getUserId())});
        this.app.setParticipants(new Participant[]{new UserParticipant(this.client1.getValues().getUserId()), new UserParticipant(this.client2.getValues().getUserId()), new UserParticipant(this.client4.getValues().getUserId())});
        InsertRequest insertRequest = new InsertRequest(this.app, this.client1.getValues().getTimeZone());
        AppointmentInsertResponse insertResponse = this.client1.execute(insertRequest);
        insertResponse.fillObject((DataObject)this.app);
        GetRequest get = new GetRequest(this.folder.getObjectID(), this.app.getObjectID());
        GetResponse getResponse = this.client2.execute(get);
        Appointment loaded = getResponse.getAppointment(this.client2.getValues().getTimeZone());
        PrivateTests.assertEquals((String)"Missing data.", (String)this.app.getLocation(), (String)loaded.getLocation());
        get = new GetRequest(this.folder.getObjectID(), this.app.getObjectID());
        getResponse = this.client3.execute(get);
        loaded = getResponse.getAppointment(this.client3.getValues().getTimeZone());
        PrivateTests.assertNull((String)"Did not expect data.", (Object)loaded.getLocation());
        get = new GetRequest(this.folder.getObjectID(), this.app.getObjectID(), false);
        getResponse = this.client4.execute(get);
        PrivateTests.assertTrue((String)"Expected error.", (boolean)getResponse.hasError());
        get = new GetRequest(this.client4.getValues().getPrivateAppointmentFolder(), this.app.getObjectID());
        getResponse = this.client4.execute(get);
        loaded = getResponse.getAppointment(this.client4.getValues().getTimeZone());
        PrivateTests.assertEquals((String)"Missing data.", (String)this.app.getLocation(), (String)loaded.getLocation());
    }

    public void testEditByParticipant() throws Exception {
        this.app = new Appointment();
        this.app.setIgnoreConflicts(true);
        this.app.setTitle("com.openexchange.ajax.appointment.PrivateTests.testBasicPrivate");
        this.app.setStartDate(TimeTools.D("01.07.2013 08:00"));
        this.app.setEndDate(TimeTools.D("01.07.2013 09:00"));
        this.app.setLocation("Hier und da");
        this.app.setPrivateFlag(true);
        this.app.setParentFolderID(this.folder.getObjectID());
        this.app.setUsers(new UserParticipant[]{new UserParticipant(this.client1.getValues().getUserId()), new UserParticipant(this.client2.getValues().getUserId()), new UserParticipant(this.client4.getValues().getUserId())});
        this.app.setParticipants(new Participant[]{new UserParticipant(this.client1.getValues().getUserId()), new UserParticipant(this.client2.getValues().getUserId()), new UserParticipant(this.client4.getValues().getUserId())});
        InsertRequest insertRequest = new InsertRequest(this.app, this.client1.getValues().getTimeZone());
        AppointmentInsertResponse insertResponse = this.client1.execute(insertRequest);
        insertResponse.fillObject((DataObject)this.app);
        Appointment updateApp = new Appointment();
        updateApp.setObjectID(this.app.getObjectID());
        updateApp.setParentFolderID(this.app.getParentFolderID());
        updateApp.setLastModified(this.app.getLastModified());
        updateApp.setPrivateFlag(false);
        UpdateRequest update = new UpdateRequest(updateApp, this.client2.getValues().getTimeZone());
        UpdateResponse updateResponse = this.client2.execute(update);
        updateResponse.fillObject((DataObject)this.app);
        GetRequest get = new GetRequest(this.folder.getObjectID(), this.app.getObjectID());
        GetResponse getResponse = this.client2.execute(get);
        Appointment loaded = getResponse.getAppointment(this.client2.getValues().getTimeZone());
        PrivateTests.assertEquals((String)"Missing data.", (String)this.app.getLocation(), (String)loaded.getLocation());
        get = new GetRequest(this.folder.getObjectID(), this.app.getObjectID());
        getResponse = this.client3.execute(get);
        loaded = getResponse.getAppointment(this.client3.getValues().getTimeZone());
        PrivateTests.assertEquals((String)"Missing data.", (String)this.app.getLocation(), (String)loaded.getLocation());
        get = new GetRequest(this.folder.getObjectID(), this.app.getObjectID(), false);
        getResponse = this.client4.execute(get);
        PrivateTests.assertTrue((String)"Expected error.", (boolean)getResponse.hasError());
        get = new GetRequest(this.client4.getValues().getPrivateAppointmentFolder(), this.app.getObjectID());
        getResponse = this.client4.execute(get);
        loaded = getResponse.getAppointment(this.client4.getValues().getTimeZone());
        PrivateTests.assertEquals((String)"Missing data.", (String)this.app.getLocation(), (String)loaded.getLocation());
    }

    @Override
    public void tearDown() throws Exception {
        this.client1.execute(new DeleteRequest(this.app));
        this.client1.execute(new com.openexchange.ajax.folder.actions.DeleteRequest((API)EnumAPI.OX_NEW, this.folder));
        super.tearDown();
    }
}

