/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment;

import com.openexchange.ajax.AppointmentTest;
import com.openexchange.ajax.appointment.action.NewAppointmentSearchRequest;
import com.openexchange.ajax.appointment.action.NewAppointmentSearchResponse;
import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.groupware.container.Appointment;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortalSearchTest
extends AppointmentTest {
    private static final Logger LOG = LoggerFactory.getLogger(PortalSearchTest.class);
    private final int[] columns = new int[]{1, 20, 101, 100, 200, 400, 201, 202, 203, 209, 402, 401, 102};

    public PortalSearchTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testNewAppointmentsSearch() throws Exception {
        Calendar calendar = Calendar.getInstance(this.timeZone);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.add(5, -2);
        Date start = calendar.getTime();
        calendar.add(1, 1);
        Date end = calendar.getTime();
        Appointment appointmentObj = this.createAppointmentObject("testNewAppointmentsSearch");
        appointmentObj.setIgnoreConflicts(true);
        int objectId = PortalSearchTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, this.getHostName(), this.getSessionId());
        appointmentObj.setObjectID(objectId);
        AJAXSession ajaxSession = new AJAXSession(this.getWebConversation(), this.getHostName(), this.getSessionId());
        NewAppointmentSearchRequest request = new NewAppointmentSearchRequest(start, end, 10000, this.timeZone, this.columns);
        NewAppointmentSearchResponse response = Executor.execute(ajaxSession, request);
        if (response.hasError()) {
            throw new Exception("json error: " + response.getResponse().getErrorMessage());
        }
        Appointment[] appointmentArray = response.getAppointments();
        boolean found = false;
        for (int a = 0; a < appointmentArray.length; ++a) {
            if (appointmentArray[a].getObjectID() != objectId) continue;
            this.compareObject(appointmentObj, appointmentArray[a]);
            found = true;
        }
        PortalSearchTest.assertTrue((String)("object with id " + objectId + " not found in response"), (boolean)found);
        PortalSearchTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, this.getHostName(), this.getSessionId(), false);
    }
}

