/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.gimap.protocol;

import com.sun.mail.gimap.GmailMsgIdTerm;
import com.sun.mail.gimap.GmailRawSearchTerm;
import com.sun.mail.gimap.GmailThrIdTerm;
import com.sun.mail.iap.Argument;
import com.sun.mail.imap.protocol.SearchSequence;
import java.io.IOException;
import javax.mail.search.SearchException;
import javax.mail.search.SearchTerm;

public class GmailSearchSequence
extends SearchSequence {
    @Override
    public Argument generateSequence(SearchTerm term, String charset) throws SearchException, IOException {
        if (term instanceof GmailMsgIdTerm) {
            return this.gmailMsgidSearch((GmailMsgIdTerm)term);
        }
        if (term instanceof GmailThrIdTerm) {
            return this.gmailThridSearch((GmailThrIdTerm)term);
        }
        if (term instanceof GmailRawSearchTerm) {
            return this.gmailRawSearch((GmailRawSearchTerm)term, charset);
        }
        return super.generateSequence(term, charset);
    }

    protected Argument gmailMsgidSearch(GmailMsgIdTerm term) throws IOException {
        Argument result = new Argument();
        result.writeAtom("X-GM-MSGID");
        result.writeNumber(term.getNumber());
        return result;
    }

    protected Argument gmailThridSearch(GmailThrIdTerm term) throws IOException {
        Argument result = new Argument();
        result.writeAtom("X-GM-THRID");
        result.writeNumber(term.getNumber());
        return result;
    }

    protected Argument gmailRawSearch(GmailRawSearchTerm term, String charset) throws IOException {
        Argument result = new Argument();
        result.writeAtom("X-GM-RAW");
        result.writeString(term.getPattern(), charset);
        return result;
    }
}

