/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.user.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.contact.ContactService;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.oauth.provider.resourceserver.annotations.OAuthAction;
import com.openexchange.server.ServiceLookup;
import com.openexchange.session.Session;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.user.json.actions.AbstractUserAction;
import org.json.JSONException;
import org.json.JSONObject;

@Action(method=RequestMethod.GET, name="GET", description="Get information about requesting user.", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module.")}, responseDescription="Response with timestamp: A JSON object providing some user information.")
@OAuthAction(value="*")
public final class MeAction
extends AbstractUserAction {
    public static final String ACTION = "GET";

    public MeAction(ServiceLookup services) {
        super(services);
    }

    public AJAXRequestResult perform(AJAXRequestData request, ServerSession session) throws OXException {
        try {
            int userId = session.getUserId();
            Context context = session.getContext();
            Contact contact = ((ContactService)this.services.getService(ContactService.class)).getUser((Session)session, userId);
            JSONObject jReturn = new JSONObject(8);
            jReturn.put("context_id", session.getContextId());
            jReturn.put("user_id", session.getUserId());
            jReturn.put("context_admin", context.getMailadmin());
            String str = session.getLoginName();
            jReturn.put("login_name", (Object)(str == null ? "<unknown>" : str));
            str = contact.getDisplayName();
            jReturn.put("display_name", (Object)(str == null ? "<unknown>" : str));
            return new AJAXRequestResult((Object)jReturn, contact.getLastModified(), "json");
        }
        catch (JSONException e) {
            throw AjaxExceptionCodes.JSON_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }
}

