/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.user.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.contact.ContactService;
import com.openexchange.contact.storage.ContactUserStorage;
import com.openexchange.contacts.json.mapping.ContactMapper;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.ldap.User;
import com.openexchange.server.ServiceLookup;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.user.UserService;
import com.openexchange.user.json.UserContact;
import com.openexchange.user.json.actions.AbstractUserAction;

@Action(method=RequestMethod.GET, name="get", description="Get a user.", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="id", optional=true, description="Object ID of the requested user. Since v6.18.1, this parameter is optional: the default is the currently logged in user.")}, responseDescription="Response with timestamp: An object containing all data of the requested user. The fields of the object are listed in Common object data, Detailed contact data and Detailed user data.")
public final class GetAction
extends AbstractUserAction {
    public static final String ACTION = "get";

    public GetAction(ServiceLookup services) {
        super(services);
    }

    public AJAXRequestResult perform(AJAXRequestData request, ServerSession session) throws OXException {
        int[] columns = GetAction.parseOptionalIntArrayParameter("columns", request);
        ContactField[] contactFields = null == columns || 0 == columns.length ? ContactMapper.getInstance().getAllFields() : (ContactField[])ContactMapper.getInstance().getFields(columns);
        String idParam = request.getParameter("id");
        int userId = null == idParam ? session.getUserId() : GetAction.checkIntParameter("id", request);
        UserService userService = (UserService)this.services.getService(UserService.class);
        User user = userService.getUser(userId, session.getContext());
        Contact contact = null;
        if (user.isGuest()) {
            ContactUserStorage contactUserStorage = (ContactUserStorage)this.services.getService(ContactUserStorage.class);
            contact = contactUserStorage.getGuestContact(session.getContextId(), userId, contactFields);
        } else {
            ContactService contactService = (ContactService)this.services.getService(ContactService.class);
            contact = contactService.getUser((Session)session, userId, contactFields);
        }
        if (contact.getInternalUserId() != user.getId() || user.getContactId() != contact.getObjectID()) {
            // empty if block
        }
        return new AJAXRequestResult((Object)new UserContact(contact, GetAction.censor(session, user)), contact.getLastModified(), "usercontact");
    }
}

