/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.user.json;

import com.openexchange.ajax.anonymizer.AnonymizerService;
import com.openexchange.ajax.anonymizer.Anonymizers;
import com.openexchange.ajax.anonymizer.Module;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.Converter;
import com.openexchange.ajax.requesthandler.ResultConverter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.ldap.User;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.user.json.UserContact;
import com.openexchange.user.json.Utility;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class UserContactResultConverter
implements ResultConverter {
    private static final Set<String> EXPECTED_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("columns", "sort", "order", "left_hand_limit", "right_hand_limit", "timezone", "session", "action")));

    public String getInputFormat() {
        return "usercontact";
    }

    public String getOutputFormat() {
        return "json";
    }

    public ResultConverter.Quality getQuality() {
        return ResultConverter.Quality.GOOD;
    }

    public void convert(AJAXRequestData requestData, AJAXRequestResult result, ServerSession session, Converter converter) throws OXException {
        String timeZoneID = requestData.getParameter("timezone");
        if (null == timeZoneID) {
            timeZoneID = session.getUser().getTimeZone();
        }
        int[] columnIDs = Utility.parseOptionalIntArrayParameter("columns", requestData);
        Map<String, List<String>> attributeParameters = Utility.getAttributeParameters(EXPECTED_NAMES, requestData);
        Object resultObject = result.getResultObject();
        if (null == resultObject) {
            resultObject = JSONObject.NULL;
        } else if ("get".equalsIgnoreCase(requestData.getAction())) {
            UserContact userContact = (UserContact)resultObject;
            if (Anonymizers.isGuest((Session)session) && null != userContact.getUser() && session.getUserId() != userContact.getUser().getId()) {
                userContact.setContact((Contact)Anonymizers.optAnonymize((Object)userContact.getContact(), (Module)Module.CONTACT, (Session)session));
                userContact.setUser((User)Anonymizers.optAnonymize((Object)userContact.getUser(), (Module)Module.USER, (Session)session));
            }
            resultObject = userContact.serialize(timeZoneID, (Session)session);
        } else {
            List userContacts = (List)resultObject;
            JSONArray jArray = new JSONArray(userContacts.size());
            if (Anonymizers.isGuest((Session)session)) {
                AnonymizerService contactAnonymizer = Anonymizers.optAnonymizerFor((Module)Module.CONTACT);
                AnonymizerService userAnonymizer = Anonymizers.optAnonymizerFor((Module)Module.USER);
                for (UserContact userContact : userContacts) {
                    if (null != userContact.getUser() && session.getUserId() != userContact.getUser().getId()) {
                        userContact.setContact((Contact)contactAnonymizer.anonymize((Object)userContact.getContact(), (Session)session));
                        userContact.setUser((User)userAnonymizer.anonymize((Object)userContact.getUser(), (Session)session));
                    }
                    jArray.put((Object)userContact.serialize((Session)session, columnIDs, timeZoneID, attributeParameters));
                }
            } else {
                for (UserContact userContact : userContacts) {
                    jArray.put((Object)userContact.serialize((Session)session, columnIDs, timeZoneID, attributeParameters));
                }
            }
            resultObject = jArray;
        }
        result.setResultObject(resultObject, "json");
    }
}

