/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.threadpool.internal;

import com.openexchange.threadpool.internal.QueueProvider;
import java.util.concurrent.BlockingQueue;

public enum QueueType {
    SYNCHRONOUS("synchronous", false, new IQueueProvider(){

        @Override
        public BlockingQueue<Runnable> newWorkQueue(int fixedCapacity) {
            return QueueProvider.getInstance().newSynchronousQueue();
        }
    }),
    LINKED("linked", true, new IQueueProvider(){

        @Override
        public BlockingQueue<Runnable> newWorkQueue(int fixedCapacity) {
            return QueueProvider.getInstance().newLinkedQueue(fixedCapacity);
        }
    });

    private final String type;
    private final IQueueProvider queueProvider;
    private final boolean fixedSize;

    private QueueType(String type, boolean fixedSize, IQueueProvider queueProvider) {
        this.fixedSize = fixedSize;
        this.type = type;
        this.queueProvider = queueProvider;
    }

    public boolean isFixedSize() {
        return this.fixedSize;
    }

    public BlockingQueue<Runnable> newWorkQueue(int fixedCapacity) {
        return this.queueProvider.newWorkQueue(fixedCapacity);
    }

    public static QueueType getQueueType(String type) {
        QueueType[] queueTypes;
        for (QueueType queueType : queueTypes = QueueType.values()) {
            if (!queueType.type.equalsIgnoreCase(type)) continue;
            return queueType;
        }
        return null;
    }

    private static interface IQueueProvider {
        public BlockingQueue<Runnable> newWorkQueue(int var1);
    }
}

