/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.threadpool.internal;

import com.openexchange.threadpool.MdcProvider;
import com.openexchange.threadpool.RefusedExecutionBehavior;
import com.openexchange.threadpool.Task;
import com.openexchange.threadpool.Trackable;
import java.util.Map;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicLong;

public class CustomFutureTask<V>
extends FutureTask<V>
implements MdcProvider {
    private static final AtomicLong COUNTER = new AtomicLong();
    private final Task<V> task;
    private final RefusedExecutionBehavior<V> refusedExecutionBehavior;
    private final long number;
    private final boolean trackable;
    private final Map<String, Object> mdcMap;

    public CustomFutureTask(Task<V> task, Map<String, Object> mdcMap) {
        this(task, null, mdcMap);
    }

    public CustomFutureTask(Task<V> task, RefusedExecutionBehavior<V> refusedExecutionBehavior, Map<String, Object> mdcMap) {
        super(task);
        this.task = task;
        this.mdcMap = mdcMap;
        this.refusedExecutionBehavior = refusedExecutionBehavior;
        this.number = COUNTER.incrementAndGet();
        this.trackable = task instanceof Trackable;
    }

    @Override
    public Map<String, Object> getMdc() {
        return this.mdcMap;
    }

    public boolean isTrackable() {
        return this.trackable;
    }

    public long getNumber() {
        return this.number;
    }

    public Task<V> getTask() {
        return this.task;
    }

    public RefusedExecutionBehavior<V> getRefusedExecutionBehavior() {
        return this.refusedExecutionBehavior;
    }

    @Override
    public void set(V v) {
        super.set(v);
    }

    @Override
    public void setException(Throwable t) {
        super.setException(t);
    }
}

